import bb.cascades 1.2

Page {
    titleBar: TitleBar {
        title: qsTr("Test dialplan")
    }
    
    actions: [
        // define the actions for first tab here
        ActionItem {
            title: qsTr("Pick Contact")
            ActionBar.placement: ActionBarPlacement.OnBar
            imageSource: "icons/large/icon_273.png"
            onTriggered: {
                _dialplan.pickContact();
            }
        }
    ]
    
    actionBarVisibility: ChromeVisibility.Visible
    Container {
        layout: StackLayout {
            orientation: LayoutOrientation.TopToBottom
        }

        topPadding: 50
        leftPadding: 20
        rightPadding: 20
        Container {
            layout: StackLayout {
                orientation: LayoutOrientation.TopToBottom
            }
            Label {
                topMargin: 2
                text: qsTr("Dialed number:")
                textStyle.base: SystemDefaults.TextStyles.SmallText
                textStyle.textAlign: TextAlign.Left
                horizontalAlignment: HorizontalAlignment.Left
                verticalAlignment: VerticalAlignment.Center
                bottomMargin: 2
            }
            TextField {
                topMargin: 2
                id: numberToTest
                inputMode: TextFieldInputMode.PhoneNumber
                hintText: "Number to test"
                text: _dialplan.testInputStr
                layoutProperties: StackLayoutProperties {
                    spaceQuota: 1.0
                }
                onTextChanging: {
                    _dialplan.testDialplan(text)
                    resultContainer.visible=(text.length>0)
                }
                verticalAlignment: VerticalAlignment.Center
            }
        }        
        Container {
            layout: StackLayout {
                orientation: LayoutOrientation.TopToBottom
            }
            visible: numberToTest.text.length>0
            topMargin: 50
            id: resultContainer
            Label {
                topMargin: 2
                text: qsTr("Result number:")
                textStyle.base: SystemDefaults.TextStyles.SmallText
                textStyle.textAlign: TextAlign.Left
                horizontalAlignment: HorizontalAlignment.Left
                verticalAlignment: VerticalAlignment.Center
                bottomMargin: 2
            }
            Label {
                topMargin: 2
                text: _dialplan.testResultStr
                textStyle.base: SystemDefaults.TextStyles.BodyText
                textStyle.textAlign: TextAlign.Left
                horizontalAlignment: HorizontalAlignment.Left
                verticalAlignment: VerticalAlignment.Center
                bottomMargin: 30
            }
            Label {
                topMargin: 2
                text: qsTr("SIP account:")
                textStyle.base: SystemDefaults.TextStyles.SmallText
                textStyle.textAlign: TextAlign.Left
                horizontalAlignment: HorizontalAlignment.Left
                verticalAlignment: VerticalAlignment.Center
                bottomMargin: 2
            }
            Label {
                topMargin: 2
                text: _dialplan.testSIPAccount
                textStyle.base: SystemDefaults.TextStyles.BodyText
                textStyle.textAlign: TextAlign.Left
                horizontalAlignment: HorizontalAlignment.Left
                verticalAlignment: VerticalAlignment.Center
                bottomMargin: 30
            }
        }        
    }
}
