import bb.cascades 1.0

Sheet {
    id:sheet
    content: Page {
	    id: accountEditPage
	
	
	    titleBar: TitleBar {
	        id: pageTitleBar
	
	        // The 'Create/Save' action
	        acceptAction: ActionItem {
	            title: (qsTr ("Save"))
	
	            onTriggered: {
	                _sipPhone.saveSipSettings();
	                sheet.close();
	            }
	        }
	
	        // The 'Cancel' action
	        dismissAction: ActionItem {
	            title: qsTr ("Cancel")
	
	            onTriggered: { 
	                sheet.close();
	            }
	        }
	    }
	
        Container {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            leftPadding: 30
            topPadding: 30
            rightPadding: 30

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 20
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1.5
	                }	
		            text: qsTr("Stun Server:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	            TextField {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
	                id: domainField
	                input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
	
	                hintText: qsTr ("StunServer (optional)")
	                text: _sipPhone.stunServer
	                onTextChanging: _sipPhone.stunServer = text
	            }
	        }

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1.5
	                }	
		            text: qsTr("Nat type in SDP:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
                DropDown {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
		            objectName: "natTypeDropDown"
		            verticalAlignment: VerticalAlignment.Center
		            horizontalAlignment: HorizontalAlignment.Left
		             
		            Option {
		                text: "None"
		                selected: _sipPhone.natTypeInSDP==0 
		                value: "0"
		                 
		            }
		            Option {
		                text: "Nat type"
		                selected: _sipPhone.natTypeInSDP==1
		                value: "1"
		            }
		            Option {
		                text: "Nat type and name"
		                selected: _sipPhone.natTypeInSDP==2
		                value: "2"
		            }
		            
		            onSelectedOptionChanged: _sipPhone.natTypeInSDP=parseInt(selectedOption.value)
		        }
		    }
            Container {
                layout: StackLayout {
                    orientation: LayoutOrientation.LeftToRight
                }
                horizontalAlignment: HorizontalAlignment.Center
                topPadding: 40
                Label {
                    text: qsTr("Allow switch to TCP:")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Right
                    horizontalAlignment: HorizontalAlignment.Right
                    verticalAlignment: VerticalAlignment.Center
                }
                
                ToggleButton {
                    id: cellDataField
                    checked: _sipPhone.allowSwitchToTCP
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    onCheckedChanged: _sipPhone.allowSwitchToTCP = checked
                }
                bottomMargin: 2
            }
            
            Label {
                topMargin: 2
                text: qsTr("switch from UDP to TCP when packet size exceeds 1300 bytes")
                textStyle.base: SystemDefaults.TextStyles.BodyText
                textStyle.textAlign: TextAlign.Center
                horizontalAlignment: HorizontalAlignment.Center
                verticalAlignment: VerticalAlignment.Center
                textStyle.fontSize: FontSize.XXSmall
            }
            Container {
                topPadding: 30
		        horizontalAlignment: HorizontalAlignment.Center
                Label {
                    text: "Note: the changes will be applied"
                    horizontalAlignment: HorizontalAlignment.Fill
                    textStyle.fontSize: FontSize.Small
                }
                Label {
                    text: "after application restart"
                    horizontalAlignment: HorizontalAlignment.Fill
                    textStyle.fontSize: FontSize.Small
                }
            }
            Divider {
               topPadding: 20
            }
            /*
            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 20
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1.5
	                }	
		            text: qsTr("Transport:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
                DropDown {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
		            objectName: "transportDropDown"
		            verticalAlignment: VerticalAlignment.Center
		            horizontalAlignment: HorizontalAlignment.Left
		             
		            Option {
		                text: "UDP"
		                selected: _sipPhone.transport==1 
		                value: "1"
		            }
		            Option {
		                text: "TCP"
		                selected: _sipPhone.transport==2
		                value: "2"
		            }
		            
		            onSelectedOptionChanged: _sipPhone.transport=parseInt(selectedOption.value)
		        }
		    }
            */
	    }
    }
}