import bb.cascades 1.0

Page {
    id: root

    onCreationCompleted: {
        // Fill the editor fields after the UI has been created
        _sipPhone.enterAccountEditing();
        domainField.text = _sipPhone.sipDomain;
        userNameField.text = _sipPhone.sipUserName;
        passwordField.text = _sipPhone.sipPassword;
        registerField.checked=_sipPhone.sipRegister
    }

    titleBar: TitleBar {
        id: pageTitleBar

        // The 'Create/Save' action
        acceptAction: ActionItem {
            title: (qsTr ("Save"))

            onTriggered: {
                _sipPhone.saveAccount();
                navigationPane.pop();
            }
        }

        // The 'Cancel' action
        dismissAction: ActionItem {
            title: qsTr ("Cancel")

            onTriggered: navigationPane.pop()
        }
    }

    Container {
        layout: DockLayout {}

        // The background image
        ImageView {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            imageSource: "asset:///images/background.png"
        }

        Container {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            leftPadding: 30
            topPadding: 30
            rightPadding: 30


	        Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	                    horizontalAlignment: HorizontalAlignment.Left
	            topPadding: 70
		        Label {
		            text: qsTr("Phone number:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Left
		            horizontalAlignment: HorizontalAlignment.Left
		            verticalAlignment: VerticalAlignment.Center
		        }
	                    
	            ToggleButton {
	                id: phoneNumberCheck
	                checked:true
		            horizontalAlignment: HorizontalAlignment.Left
		            verticalAlignment: VerticalAlignment.Center
	                onCheckedChanged: destinationText.inputMode = checked?TextFieldInputMode.PhoneNumber:TextFieldInputMode.Text
	            }
	        }
		     Container {
		        layout: StackLayout {
		                    orientation: LayoutOrientation.TopToBottom
		                }
		         topPadding: 70
		         horizontalAlignment: HorizontalAlignment.Center
			     Button {
		            text: qsTr("CALL")
		            
		            horizontalAlignment: HorizontalAlignment.Center
		            imageSource: "asset:///icons/Dial.png"
		            onClicked: {
		                _sipPhone.dial(destText.text);
		            }
			     }
		    }
	        Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
		       topMargin: 80
		       TextField {
		            objectName: "statusText"
		            visible: false
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            verticalAlignment: VerticalAlignment.Center
		            horizontalAlignment: HorizontalAlignment.Left
	                    input.submitKey: SubmitKey.Connect
	                }
		   }
        }
    }
}