import bb.cascades 1.0

Page {
    id: root

    /*
    attachedObjects: [
        ComponentDefinition {
            id: sipSettingsEditor
            source: "SipSettingsEditor.qml"
        },    
        ComponentDefinition {
            id: notifySettingsEditor
            source: "NotifySettingsEditor.qml"
        }    
    ]   
    */
    titleBar: TitleBar {
        id: pageTitleBar
        title: "Mobile data"
    }

    Container {
        layout: DockLayout {}

        Container {
            horizontalAlignment: HorizontalAlignment.Center
            verticalAlignment: VerticalAlignment.Fill

            leftPadding: 30
            topPadding: 30
            rightPadding: 30

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	                    horizontalAlignment: HorizontalAlignment.Center
	            topPadding: 40
		        Label {
		            text: qsTr("Use cellular data:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	                    
                ToggleButton {
                    id: cellDataField
                    checked: _sipPhone.cellDataAllowed
		            horizontalAlignment: HorizontalAlignment.Left
		            verticalAlignment: VerticalAlignment.Center
                    onCheckedChanged: _sipPhone.cellDataAllowed = checked
                }
            }
            Container {
                topPadding: 10
		        horizontalAlignment: HorizontalAlignment.Center
                Label {
                    text: "Note: using cellular data may incur"
                    horizontalAlignment: HorizontalAlignment.Fill
                    textStyle.fontSize: FontSize.Small
                }
                Label {
                    text: "additional charges and"
                    horizontalAlignment: HorizontalAlignment.Fill
                    textStyle.fontSize: FontSize.Small
                }
                Label {
                    text: "affect battery life of your device"
                    horizontalAlignment: HorizontalAlignment.Fill
                    textStyle.fontSize: FontSize.Small
                }
            }
        }
    }
    /*
    actions: [
        ActionItem {
            title: "More settings"
            imageSource: "icons/icon_140.png"
            ActionBar.placement: ActionBarPlacement.OnBar
            onTriggered: {
                _sipPhone.enterSipSettingEditing();
                sipSettingsEditor.createObject().open();
            }
        },
        ActionItem {
            title: "Notification"
            imageSource: "asset:///icons/icon_123.png"
            ActionBar.placement: ActionBarPlacement.OnBar
            onTriggered: {
                _sipPhone.enterNotifySettingEditing();
                notifySettingsEditor.createObject().open();
            }
        }
    ]
    */
}