import bb.cascades 1.3

Sheet {
    id:modeSheet
    attachedObjects: [
        ComponentDefinition {
            id: purchaseSheet
            source: "Purchases.qml"
        }    
    ]
    Page {
        titleBar: TitleBar {
            id: pageTitleBar
            
            // The 'Create/Save' action
            acceptAction: ActionItem {
                title: (qsTr ("Save"))
                
                onTriggered: {
                    _sipPhone.setServiceMode(regModeSelector.selectedIndex)
                    onTriggered: modeSheet.close();
                }
            }
            
            // The 'Cancel' action
            dismissAction: ActionItem {
                title: qsTr ("Cancel")
                
                onTriggered: modeSheet.close();
            }
            title: qsTr("Service Mode")
    
        }
        
        Container {
            topMargin: 20
            leftPadding: 20
            rightPadding: 20
            Label {
                text: qsTr("SIP Registration:")
            }
            RadioGroup {
                id: regModeSelector
                verticalAlignment: VerticalAlignment.Center
                
                Option {
                    text: qsTr("Active frame")
                    description: "sip should be running as Active Frame"
                    selected: _sipPhone.serviceMode==0
                }
                Option {
                    text: qsTr("Headless local")
                    description: "frequent re-reg needed when behind firewall"
                    selected: _sipPhone.serviceMode==1
                }
                Option {
                    text: qsTr("Headless remote")
                    description: "registration through sip.fm proxy"
                    selected: _sipPhone.serviceMode==2
                }
            }
    
        }
    }
}
