import bb.cascades 1.2

Sheet {
    id:rtSheet
    attachedObjects: [
        ComponentDefinition {
            id: purchaseSheet
            source: "Purchases.qml"
        }    
    ]
       
    Page {
        titleBar: TitleBar {
            title: qsTr("Ringtone")
            // The 'Create/Save' action
            acceptAction: ActionItem {
                title: (qsTr ("Save"))
                
                onTriggered: {
                    if (_sipPhone.commitRingtone()) {
                        id:rtSheet.close();
                    } else {
                        purchaseSheet.createObject().open()
                    }
                }
            }
            
            // The 'Cancel' action
            dismissAction: ActionItem {
                title: qsTr ("Cancel")
                
                onTriggered: { 
                    id:rtSheet.close();
                }
            }
        }
        onCreationCompleted: {
            _sipPhone.prepareRingtoneDetails();
            if (_sipPhone.ringtoneFileName.length==0) {
                _sipPhone.selectRingtone();
            }
        }
        
        Container {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill
            
            leftPadding: 30
            topPadding: 30
            rightPadding: 30
            Container {
                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                    
                Label {
                    text: qsTr("File name:")+(_sipPhone.ringtoneFileName.length==0?qsTr("not set, use default"):_sipPhone.ringtoneFileName)
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Left
                    textStyle.fontSize: FontSize.Small
                    textStyle.textAlign: TextAlign.Center
                    //preferredWidth: 800
                    textStyle.fontStyle: FontStyle.Italic
                }
                Label {
                    visible: _sipPhone.ringtoneFileName.length>0
                    text: qsTr("Path:")+_sipPhone.ringtonePath
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Left
                    textStyle.fontSize: FontSize.Small
                    textStyle.textAlign: TextAlign.Center
                    textStyle.fontStyle: FontStyle.Italic
                }
                Label {
                    visible: _sipPhone.ringtoneFileName.length>0
                    text: qsTr("Size:")+_sipPhone.ringtoneSize+"K"
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Left
                    textStyle.fontSize: FontSize.Small
                    textStyle.textAlign: TextAlign.Center
                    textStyle.fontStyle: FontStyle.Italic
                }
            }
            Container {
                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                verticalAlignment: VerticalAlignment.Center
                horizontalAlignment: HorizontalAlignment.Center
                
                topMargin: 32
                Button {
                    topMargin: 24
                    preferredWidth: 600
                    visible: _sipPhone.ringtoneFileName.length>0
                    text: qsTr("Play ringtone")
                    onClicked: {
                        _sipPhone.playRingtone();
                    }
                }
                
                Button {
                    topMargin: 24
                    preferredWidth: 600
                    text: _sipPhone.ringtoneFileName.length==0?qsTr("Set ringtone"):qsTr("Select another ringtone")
                    onClicked: {
                        _sipPhone.selectRingtone();
                    }
                }
                Button {
                    topMargin: 24
                    preferredWidth: 600
                    text: qsTr("Use default ringtone")
                    enabled: _sipPhone.ringtonePath.length>0
                    onClicked: {
                        _sipPhone.clearRingtone();
                    }
                }
            }
        
        }
    }
}
