import bb.cascades 1.0

Page {
    id: root

    titleBar: TitleBar {
        id: pageTitleBar
        title: "Registration account settings"
    }

    Container {
        layout: DockLayout {}

        Container {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            leftPadding: 30
            topPadding: 30
            rightPadding: 30

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1
	                }	
		            text: qsTr("Registrar:")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	            TextArea {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
	                id: registrarField
                    input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
		
	                hintText: qsTr ("will use domain if empty")
	                text: _sipPhone.sipRegistrar
	                onTextChanging: _sipPhone.sipRegistrar = text
	            }
	        }
            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1
	                }	
		            text: qsTr("Reg.timeout(sec):")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	            TextArea {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
	                id: regTimeoutField
                    input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
                    inputMode: TextFieldInputMode.NumbersAndPunctuation
		
	                hintText: qsTr ("Enter registration timeout")
	                text: _sipPhone.sipRegTimeout.toString()
	                onTextChanging: _sipPhone.sipRegTimeout = parseInt(text)
	            }
		    }
        }
    }
}