import bb.cascades 1.2
import bb.system 1.0

Page {
    titleBar: TitleBar {
        title: qsTr("Purchases")
    }
    
    actions: [
        // define the actions for first tab here
        ActionItem {
            title: qsTr("Refresh")
            ActionBar.placement: ActionBarPlacement.OnBar
            imageSource: "icons/large/refresh.png"
            onTriggered: {
                refreshingIndicator.start();
                _purchaseManager.refreshPurchases();
            }
        }
    ]
    
    actionBarVisibility: ChromeVisibility.Visible
    Container {
        layout: StackLayout {
            orientation: LayoutOrientation.TopToBottom
        }

        Container {
            layout: DockLayout {
            }
            horizontalAlignment: HorizontalAlignment.Left
            Container {
                leftPadding: 10
                rightPadding: 10
                topPadding: 50
                bottomPadding: 0
                ActivityIndicator {
                    id: refreshingIndicator
                    visible: _purchaseManager.refreshing
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Center
                    preferredWidth: 300.0
                    preferredHeight: 300.0
                }
            }
            Container {
                leftPadding: 10
                rightPadding: 10
                topPadding: 20
                bottomPadding: 0
                
                visible: _purchaseManager.purchases==0
                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                horizontalAlignment: HorizontalAlignment.Left
                verticalAlignment: VerticalAlignment.Center
                
                Label {
                    topMargin: 20
                    text: qsTr("sip.fm Premium Edition:")
                    textStyle.base: SystemDefaults.TextStyles.TitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: qsTr("sip.fm premium lets you configure multiple SIP")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                    textStyle.fontSize: FontSize.Small
                }
                Label {
                    topMargin: 2
                    text: qsTr("accounts, headless service, custom ringtone")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 10
                    textStyle.fontSize: FontSize.Small
                }
                Label {
                    topMargin: 2
                    text: qsTr("Selection of account for outbound call")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                    textStyle.fontSize: FontSize.Small
                }
                Label {
                    topMargin: 2
                    text: qsTr("can be done manually or using dial plan.")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 48
                    textStyle.fontSize: FontSize.Small
                }
                Container {
                    layout: StackLayout {
                        orientation: LayoutOrientation.LeftToRight
                    }
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Fill
                    Button {
                        text: "Get sip.fm premium"
                        verticalAlignment: VerticalAlignment.Center
                        horizontalAlignment: HorizontalAlignment.Center
                        preferredWidth: 700
                        onClicked: {
                            _purchaseManager.startPurchase();
                        }
                    }
                    /*                
                    Button {
                        text: "Not now"
                        verticalAlignment: VerticalAlignment.Center
                        horizontalAlignment: HorizontalAlignment.Center
                        onClicked: {
                            navigationPane.pop();
                        }
                    }
    *               */
                }
            }
            Container {
                leftPadding: 10
                rightPadding: 10
                topPadding: 50
                bottomPadding: 0
                
                visible: _purchaseManager.purchases>0
                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                
                Label {
                    topMargin: 20
                    text: qsTr("Product:")
                    textStyle.base: SystemDefaults.TextStyles.SubtitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: _purchaseManager.product
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 20
                }
                Label {
                    topMargin: 20
                    text: qsTr("Product SKU:")
                    textStyle.base: SystemDefaults.TextStyles.SubtitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: _purchaseManager.productSKU
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 20
                }
                Label {
                    topMargin: 20
                    text: qsTr("Purchase date:")
                    textStyle.base: SystemDefaults.TextStyles.SubtitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: _purchaseManager.purchaseDate
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 20
                }
            }
        }
        Divider {
        
        }
        
        Container {
            layout: DockLayout {
            }
            horizontalAlignment: HorizontalAlignment.Left
            Container {
                leftPadding: 10
                rightPadding: 10
                topPadding: 20
                bottomPadding: 0
                
                visible: _purchaseManager.subscriptions==0
                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                horizontalAlignment: HorizontalAlignment.Center
                verticalAlignment: VerticalAlignment.Center
                
                Label {
                    topMargin: 20
                    text: qsTr("sip.fm subscription:")
                    textStyle.base: SystemDefaults.TextStyles.TitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: qsTr("sip.fm cloud services sends push for incoming call")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                    textStyle.fontSize: FontSize.Small
                }
                Label {
                    topMargin: 2
                    text: qsTr("notification. It allows both headless service and lower")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 10
                    textStyle.fontSize: FontSize.Small
                }
                Label {
                    topMargin: 2
                    text: qsTr("battery and network consumption")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                    textStyle.fontSize: FontSize.Small
                }
                Container {
                    layout: StackLayout {
                        orientation: LayoutOrientation.TopToBottom
                    }
                    topMargin: 20
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Fill
                    Button {
                        text: "Activate sip.fm subscription now"
                        verticalAlignment: VerticalAlignment.Center
                        horizontalAlignment: HorizontalAlignment.Center
                        preferredWidth: 700
                        onClicked: {
                            _purchaseManager.startSubscription();
                        }
                    }
                }
                Label {
                    topMargin: 2
                    text: qsTr("(30 days free trial)")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Center
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                    textStyle.fontSize: FontSize.XSmall
                }
            }
            Container {
                leftPadding: 10
                rightPadding: 10
                topPadding: 50
                bottomPadding: 0
                
                visible: _purchaseManager.subscriptions>0
                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                horizontalAlignment: HorizontalAlignment.Left
                
                Label {
                    topMargin: 20
                    text: qsTr("Subscription:")
                    textStyle.base: SystemDefaults.TextStyles.SubtitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: _purchaseManager.subscription
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 20
                }
                Label {
                    topMargin: 20
                    text: qsTr("Purchase date:")
                    textStyle.base: SystemDefaults.TextStyles.SubtitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: _purchaseManager.subscriptionDate
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 20
                }
                Container {
                    layout: StackLayout {
                        orientation: LayoutOrientation.TopToBottom
                    }
                    topMargin: 20
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Center
                    Button {
                        text: "Cancel subscription"
                        verticalAlignment: VerticalAlignment.Center
                        horizontalAlignment: HorizontalAlignment.Center
                        preferredWidth: 700
                        attachedObjects: [
                            SystemDialog {
                                id: myQmlDialog
                                title: qsTr("Warning")
                                body: qsTr ("Are you sure you want to cancel subscription?")
                                onFinished: {
                                    if (myQmlDialog.result ==
                                    SystemUiResult. ConfirmButtonSelection)
                                        _purchaseManager.cancelSubscription();
                                }
                            }
                        ]
                        onClicked: {
                            myQmlDialog.show();
                        }
                    }
                }
            }
        }
    }
}
