import bb.cascades 1.0
import bb.system 1.0

Sheet {
    id:purchaseSheet
    
	Page {
	   titleBar: TitleBar {
	        title: qsTr("Purchases")
	    }
	    
	    actionBarVisibility: ChromeVisibility.Visible
	    Container {
	        layout: DockLayout {
	        }
            horizontalAlignment: HorizontalAlignment.Center
	        Container {
	            leftPadding: 10
	            rightPadding: 10
	            topPadding: 50
	            bottomPadding: 0
	            
	           visible: _sipPhone.purchases==0
	           layout: StackLayout {
	                orientation: LayoutOrientation.TopToBottom
	            }
	            
	            Label {
	                topMargin: 20
	                text: qsTr("sip.fm Premium Edition:")
	                textStyle.base: SystemDefaults.TextStyles.TitleText
	                textStyle.textAlign: TextAlign.Left
	                horizontalAlignment: HorizontalAlignment.Left
	                verticalAlignment: VerticalAlignment.Center
	                bottomMargin: 2
	            }
	            Label {
	                topMargin: 2
	                text: qsTr("sip.fm premium lets you configure ")
	                textStyle.base: SystemDefaults.TextStyles.BodyText
	                textStyle.textAlign: TextAlign.Left
	                horizontalAlignment: HorizontalAlignment.Left
	                verticalAlignment: VerticalAlignment.Center
	                bottomMargin: 2
	            }
                Label {
                    topMargin: 2
                    text: qsTr("multiple SIP accounts and")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 10
                }
                Label {
                    topMargin: 2
                    text: qsTr("and set ringtone of your choice.")
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 10
                }
	            Label {
	                topMargin: 2
	                text: qsTr("Selection of account for outbound call")
	                textStyle.base: SystemDefaults.TextStyles.BodyText
	                textStyle.textAlign: TextAlign.Left
	                horizontalAlignment: HorizontalAlignment.Left
	                verticalAlignment: VerticalAlignment.Center
	                bottomMargin: 2
	            }
	            Label {
	                topMargin: 2
	                text: qsTr("can be done manually or using dial plan.")
	                textStyle.base: SystemDefaults.TextStyles.BodyText
	                textStyle.textAlign: TextAlign.Left
	                horizontalAlignment: HorizontalAlignment.Left
	                verticalAlignment: VerticalAlignment.Center
	                bottomMargin: 48
	            }
                Container {
                    layout: StackLayout {
                        orientation: LayoutOrientation.LeftToRight
                    }
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Center
	                Button {
	                    text: "Get sip.fm premium"
	                    verticalAlignment: VerticalAlignment.Center
	                    horizontalAlignment: HorizontalAlignment.Center
	                    onClicked: {
                            purchaseSheet.close()
	                        _purchaseManager.startPurchase();
	                    }
	                }
	            
	               Button {
	                    text: "Not now"
	                    verticalAlignment: VerticalAlignment.Center
	                    horizontalAlignment: HorizontalAlignment.Center
	                    onClicked: {
	                        purchaseSheet.close()
	                    }
	                }
	           }
	        }
            Container {
                leftPadding: 10
                rightPadding: 10
                topPadding: 50
                bottomPadding: 0
                
                visible: _sipPhone.purchases>0
                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                
                Label {
                    topMargin: 20
                    text: qsTr("Product:")
                    textStyle.base: SystemDefaults.TextStyles.SubtitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: _purchaseManager.product
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 20
                }
                Label {
                    topMargin: 20
                    text: qsTr("Product SKU:")
                    textStyle.base: SystemDefaults.TextStyles.SubtitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: _purchaseManager.productSKU
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 20
                }
                Label {
                    topMargin: 20
                    text: qsTr("Purchase date:")
                    textStyle.base: SystemDefaults.TextStyles.SubtitleText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 2
                }
                Label {
                    topMargin: 2
                    text: _purchaseManager.purchaseDate
                    textStyle.base: SystemDefaults.TextStyles.BodyText
                    textStyle.textAlign: TextAlign.Left
                    horizontalAlignment: HorizontalAlignment.Left
                    verticalAlignment: VerticalAlignment.Center
                    bottomMargin: 20
                }
                Container {
                    layout: StackLayout {
                        orientation: LayoutOrientation.LeftToRight
                    }
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Center
                    Button {
                        text: "Close"
                        verticalAlignment: VerticalAlignment.Center
                        horizontalAlignment: HorizontalAlignment.Right
                        onClicked: {
                            purchaseSheet.close()
                        }
                    }
                }
            }
	    }
	}
}