import bb.cascades 1.0

Page {
    id: optionsSelectionPage
    
    titleBar: TitleBar {
        id: pageTitleBar
        title: "Options"
    }

    attachedObjects: [
        ComponentDefinition {
            id: accountEditor
            source: "AccountEditor.qml"
        },    
        ComponentDefinition {
            id: accountsPage
            source: "AccountsPage.qml"
        },    
       ComponentDefinition {
                id: settingsEditor
                source: "SettingEditor.qml"
       },    
        ComponentDefinition {
            id: sipSettingsEditor
            source: "SipSettingsEditor.qml"
        },    
        ComponentDefinition {
            id: notifySettingsEditor
            source: "NotifySettingsEditor.qml"
        },
        ComponentDefinition {
            id: audioCodecsEditor
            source: "AudioCodecsEditor.qml"
        },
        ComponentDefinition {
            id: ringtoneEditor
            source: "RingtoneEditor.qml"
        },
        ComponentDefinition {
            id: dialPlanEditor
            source: "DialingPlan.qml"
        },    
        ComponentDefinition {
            id: purchasesPage
            source: "PurchasesPage.qml"
        },
        ComponentDefinition {
            id: msgLogPage
            source: "MessageTraces.qml"
        },
        ComponentDefinition {
            id: serviceMode
            source: "ServiceMode.qml"
        }
    ]   
    Container {
        layout: DockLayout {}
        ListView {
            id: optionsListView
            dataModel: XmlDataModel {
                id:optionsDataModel
                source: "options.xml"
            } 
            /*
            listItemComponents: [
                ListItemComponent {
                    type: "option"
         
                    Container {
                        id: itemRoot
        	            layout: StackLayout {
        	                orientation: LayoutOrientation.LeftToRight
        	            }
        		       topMargin: 8
        		       bottomMargin: 8
                        
         
                        ImageView {
                            imageSource: ListItemData.icon

                            //opacity: itemRoot.ListItem.selected ? 1.0 : 0.5
                        }
         
                        Label { text: ListItemData.name
                            textStyle.fontSize: FontSize.XLarge
                        }
                    }
                }
            ] 
            */
                          
            listItemComponents: ListItemComponent {
                type: "option"

                StandardListItem {
                    id: histItem
                    title: ListItemData.name
                    description: ListItemData.dsc
                    imageSource: ListItemData.icon
                }
            }
            
            onTriggered: {
                clearSelection()
                select(indexPath)

                //_sipPhone.dialFromCallHistory(indexPath)
                var selectedItem = dataModel.data(indexPath);
                if (selectedItem.id==1) {
                    //_sipPhone.enterAccountEditing();
                    //accountEditor.createObject().open();
                    _sipPhone.activeNavigationPane.push(accountsPage.createObject());
                } else if (selectedItem.id==2){
                    //navigationPane.push(settingsEditor.createObject());
                    _sipPhone.activeNavigationPane.push(settingsEditor.createObject());
                } else if (selectedItem.id==9){
                    _sipPhone.activeNavigationPane.push(dialPlanEditor.createObject());
                } else if (selectedItem.id==3){
	                _sipPhone.enterSipSettingEditing();
                    sipSettingsEditor.createObject().open();
                } else if (selectedItem.id == 4) {
                    _sipPhone.enterNotifySettingEditing();
                    notifySettingsEditor.createObject().open();
                } else if (selectedItem.id == 5) {
                    audioCodecsEditor.createObject().open();
                } else if (selectedItem.id == 6) {
                    _invController.contactDeveloper();
                } else if (selectedItem.id == 7) {
                    _invController.rateApp();
                } else if (selectedItem.id == 8) {
                    _bbmController.sendInvToDownload();
                } else if (selectedItem.id == 10) {
                    _sipPhone.activeNavigationPane.push(purchasesPage.createObject());
                } else if (selectedItem.id == 11) {
                    _sipPhone.activeNavigationPane.push(msgLogPage.createObject());
                } else if (selectedItem.id == 12) {
                    ringtoneEditor.createObject().open();
                } else if (selectedItem.id == 13) {
                    serviceMode.createObject().open();
                }

                clearSelection()
            } 
        }
    }
}
