import bb.cascades 1.0

Sheet {
    id:sheet
    	content: Page {
	    id: notifySettingsPage
	
	
	    titleBar: TitleBar {
	        id: pageTitleBar
	        title: "Notification"

	        // The 'Create/Save' action
	        acceptAction: ActionItem {
	            title: (qsTr ("Save"))
	
	            onTriggered: {
	                _sipPhone.saveNotifySettings();
	                sheet.close();
	            }
	        }
	
	        // The 'Cancel' action
	        dismissAction: ActionItem {
	            title: qsTr ("Cancel")
	
	            onTriggered: { 
	                sheet.close();
	            }
	        }
	    }
	
        Container {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            leftPadding: 30
            topPadding: 30
            rightPadding: 30

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
	            /*
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1.5
	                }	
		            text: qsTr("Led:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
		        */
                DropDown {
	                //layoutProperties: StackLayoutProperties {
	                //     spaceQuota: 2
	                //}	
		            objectName: "ledColorDropDown"
		            verticalAlignment: VerticalAlignment.Center
		            horizontalAlignment: HorizontalAlignment.Fill
		            title: "Led:"
		            Option {
		                imageSource: "icons/blackled.png"
		                text: "None"
		                selected: _sipPhone.notifyLedColor==0 
		                value: "0"
		            }
		            Option {
		                imageSource: "icons/redled.png"
		                text: "Red"
		                selected: _sipPhone.notifyLedColor==0xFF0000; 
		                value: "FF0000"
		            }
		            Option {
		                imageSource: "icons/greenled.png"
		                text: "Green"
		                selected: _sipPhone.notifyLedColor==0x00FF00; 
		                value: "00FF00"
		            }
		            Option {
		                imageSource: "icons/blueled.png"
		                text: "Blue"
		                selected: _sipPhone.notifyLedColor==0x0000FF; 
		                value: "0000FF"
		            }
		            Option {
		                imageSource: "icons/yellowled.png"
		                text: "Yellow"
		                selected: _sipPhone.notifyLedColor==0xFFFF00; 
		                value: "FFFF00"
		            }
		            Option {
		                imageSource: "icons/magentaled.png"
		                text: "Magenta"
		                selected: _sipPhone.notifyLedColor==0xFF00FF; 
		                value: "FF00FF"
		            }
		            Option {
		                imageSource: "icons/cyanled.png"
		                text: "Cyan"
		                selected: _sipPhone.notifyLedColor==0x00FFFF; 
		                value: "00FFFF"
		            }
		            Option {
		                imageSource: "icons/whiteled.png"
		                text: "White"
		                selected: _sipPhone.notifyLedColor==0xFFFFFF; 
		                value: "FFFFFF"
		            }
		            onSelectedOptionChanged: _sipPhone.notifyLedColor=parseInt(selectedOption.value,16)
		        }
		    }
		    
            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1.5
	                }	
		            text: qsTr("Vibrate:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
                Container {
	               layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2.0
	                }	
			        Label {
		                layoutProperties: StackLayoutProperties {
		                     spaceQuota: 0.75
		                }	
		                id: vibrationTimes
		                objectName: vibrationTimes
			            textStyle.base: SystemDefaults.TextStyles.BodyText
			            verticalAlignment: VerticalAlignment.Center
			            horizontalAlignment: HorizontalAlignment.Left
			        }
			        Slider {
		                layoutProperties: StackLayoutProperties {
		                     spaceQuota: 1.25
		                }
		                id: vibrationSlider
		                value: _sipPhone.notifyVibration	
			            verticalAlignment: VerticalAlignment.Center
			            horizontalAlignment: HorizontalAlignment.Left
			            fromValue: 0
			            toValue: 12
			            onImmediateValueChanged: {
			                    var times=Math.round(immediateValue);
			                    _sipPhone.notifyVibration=times;
			                    var timesStr="None";
			                    if (times==1) timesStr="one time";
			                    else if (times>1) timesStr=times.toString()+" times";
			                    vibrationTimes.text=timesStr;
			            } 
			        }
			    }
	        }
            Divider {
                 topPadding: 20
            }
            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            horizontalAlignment: HorizontalAlignment.Center
	            verticalAlignment: VerticalAlignment.Center
	            topPadding: 25
		        Label {
		            text: qsTr("Ringer:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
                ToggleButton {
	                id: ringerToggle
	                objectName: ringerToggle
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		            checked: _sipPhone.notifyRinging
                    onCheckedChanged: {
                        _sipPhone.notifyRinging=checked
                    }
                }
		    }
            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 35
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1.5
	                }	
		            text: qsTr("Delay ringer:")
		            textStyle.base: SystemDefaults.TextStyles.BodyText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
                Container {
	               layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2.0
	                }	
			        Label {
		                layoutProperties: StackLayoutProperties {
		                     spaceQuota: 0.75
		                }	
		                id: delayRingerSec
		                objectName: delayRingerSec
			            textStyle.base: SystemDefaults.TextStyles.BodyText
			            verticalAlignment: VerticalAlignment.Center
			            horizontalAlignment: HorizontalAlignment.Left
			        }
			        Slider {
		                layoutProperties: StackLayoutProperties {
		                     spaceQuota: 1.25
		                }
		                id: delayRingerSlider
		                value: _sipPhone.notifyRingingDelay	
			            verticalAlignment: VerticalAlignment.Center
			            horizontalAlignment: HorizontalAlignment.Left
			            fromValue: 0
			            toValue: 10
			            onImmediateValueChanged: {
			                    var times=Math.round(immediateValue);
			                    _sipPhone.notifyRingingDelay=times;
			                    var timesStr=times.toString()+" sec";
			                    delayRingerSec.text=timesStr;
			            } 
			        }
			    }
	        }
	    }
    }
}