import bb.cascades 1.0

Page {
    id: root

    titleBar: TitleBar {
        id: pageTitleBar
        title: "NAT account settings"
    }

    Container {
        layout: DockLayout {}

        Container {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            leftPadding: 30
            topPadding: 30
            rightPadding: 30

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1
	                }	
		            text: qsTr("Keep alive interval (sec):")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	            TextArea {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1
	                }	
	                id: keepAliveField
                    input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
                    inputMode: TextFieldInputMode.NumbersAndPunctuation
		
	                hintText: qsTr ("Keep alive interval(sec)")
	                text: _sipPhone.sipKAInterval.toString()
	                onTextChanging: _sipPhone.sipKAInterval = parseInt(text)
	            }
		    }
		    Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	            }
	            horizontalAlignment: HorizontalAlignment.Center
	            topPadding: 40
		        Label {
		            preferredWidth: 280
		            text: qsTr("Allow contact rewrite:")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
                ToggleButton {
		            horizontalAlignment: HorizontalAlignment.Left
		            verticalAlignment: VerticalAlignment.Center
		            checked: _sipPhone.sipAllowContactOverride
                    onCheckedChanged: _sipPhone.sipAllowContactOverride = checked
                }
		    }
		    Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	            }
	            horizontalAlignment: HorizontalAlignment.Center
	            topPadding: 20
		        Label {
		            text: qsTr("Allow via rewrite:")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            preferredWidth: 280
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
                ToggleButton {
		            horizontalAlignment: HorizontalAlignment.Left
		            verticalAlignment: VerticalAlignment.Center
		            checked: _sipPhone.sipAllowViaOverride
                    onCheckedChanged: _sipPhone.sipAllowViaOverride = checked
                }
		    }
        }
    }
}