import bb.cascades 1.2

Page {
    titleBar: TitleBar {
        title: qsTr("Message traces")
    }
    actions: [
        // define the actions for first tab here
        ActionItem {
            title: qsTr("Clear traces")
            ActionBar.placement: ActionBarPlacement.OnBar
            imageSource: "icons/icon_099.png"
            onTriggered: {
                _sipPhone.clearMsgLog();
            }
        }
    ]
    Container {
        ListView {
            id: accountsListView
            dataModel: _sipPhone.msgLog
            signal editAccount(string accountID)
            signal deleteAccount(string accountID)
            
            listItemComponents : [ 
                ListItemComponent {
                    type: "item"
                    
                    StandardListItem {
                        id: msgItem
                        title: ListItemData.info
                        description: ListItemData.address+":"+ListItemData.port+"/"+ListItemData.transp+";"+ListItemData.timeStr
                        //status: ListItemData.time.toString("hh:mm:ss");
                        imageSource: ListItemData.rx==true?"asset:///icons/large/rx_arrow.png":"asset:///icons/large/tx_arrow.png"
                    }
                }
            ]
        }
    }
}
