import bb.cascades 1.0

Sheet {
    id: sheet
    content: Page {
        id: editDialplanPage
        onCreationCompleted: {
            _sipPhone.populateSipAccountsDropBox(sipAccountDropBox,_dialplan.accountID)
        }

        titleBar: TitleBar {
            id: pageTitleBar
            title: _dialplan.matchType==0?qsTr("Catch All Entry"):qsTr("Dial Plan Entry")

            // The 'Create/Save' action
            acceptAction: ActionItem {
                title: (_dialplan.adding? qsTr("Add"):qsTr("Save"))
                onTriggered: {
                    if (_dialplan.saveDialplan()) {
                    	sheet.close();
                    }
                }
            }

            // The 'Cancel' action
            dismissAction: ActionItem {
                title: qsTr("Cancel")

                onTriggered: {
                    sheet.close();
                }
            }
        }

        ScrollView {
            scrollViewProperties.scrollMode: ScrollMode.Vertical
            scrollViewProperties.overScrollEffectMode: OverScrollEffectMode.OnScroll
	        Container {
	            horizontalAlignment: HorizontalAlignment.Fill
	            verticalAlignment: VerticalAlignment.Fill
	
	            leftPadding: 10
	            topPadding: 20
	            rightPadding: 10
	
	            Container {
	                layout: StackLayout {
	                    orientation: LayoutOrientation.TopToBottom
	                }
	                topPadding: 30
	                bottomPadding: 30
	                bottomMargin: 30
	
	                Container {
	                    layout: StackLayout {
	                        orientation: LayoutOrientation.TopToBottom
	                    }
	                    visible: _dialplan.matchType==0
	                    bottomPadding: 30
	                    bottomMargin: 30
	                    Label {
	                        text: qsTr("Dialplan: Catch All")
	                        textStyle.base: SystemDefaults.TextStyles.BodyText
	                        textStyle.textAlign: TextAlign.Left
	                        horizontalAlignment: HorizontalAlignment.Left
	                        verticalAlignment: VerticalAlignment.Center
	                        bottomMargin: 4
	                    }
	                    Label {
	                        topMargin: 2
	                        text: qsTr("This entry will be applied only if no other entry matched")
	                        textStyle.base: SystemDefaults.TextStyles.SmallText
	                        textStyle.textAlign: TextAlign.Left
	                        horizontalAlignment: HorizontalAlignment.Left
	                        verticalAlignment: VerticalAlignment.Center
	                        bottomMargin: 2
	                    }
	                    Label {
	                        topMargin: 2
	                        text: qsTr("It cannot be removed")
	                        textStyle.base: SystemDefaults.TextStyles.SmallText
	                        textStyle.textAlign: TextAlign.Left
	                        horizontalAlignment: HorizontalAlignment.Left
	                        verticalAlignment: VerticalAlignment.Center
	                    }
	                }
	                
	                Container {
	                    layout: StackLayout {
	                        orientation: LayoutOrientation.TopToBottom
	                    }
	                    bottomPadding: 30
	                    bottomMargin: 30
	                    Label {
	                        topMargin: 2
	                        text: qsTr("Matching criteria")
	                        textStyle.base: SystemDefaults.TextStyles.SmallText
	                        textStyle.textAlign: TextAlign.Left
	                        horizontalAlignment: HorizontalAlignment.Left
	                        verticalAlignment: VerticalAlignment.Center
	                        bottomMargin: 2
	                    }
	                    Container {
	                        layout: StackLayout {
	                            orientation: LayoutOrientation.LeftToRight
	                        }
	                        
	                        topMargin: 2
	                        DropDown {
	                            id: matchDropBox
	                            layoutProperties: StackLayoutProperties {
	                                spaceQuota: 1.0
	                            }
	                            Option {
	                                text: qsTr("Start with")
	                                value: "2"
	                                selected: _dialplan.matchType == 2
	                            }
	                            Option {
	                                text: qsTr("Equals")
	                                value: "1"
	                                selected: _dialplan.matchType == 1
	                            }
	                            
	                            onSelectedOptionChanged: _dialplan.matchType = parseInt(selectedOption.value)
	                            verticalAlignment: VerticalAlignment.Center
	                        }
	                        TextField {
	                            inputMode: TextFieldInputMode.Text
	                            text: _dialplan.matchValue
	                            layoutProperties: StackLayoutProperties {
	                                spaceQuota: 1.0
	                            }
	                            onTextChanging: {
	                                _dialplan.matchValue = text
	                            }
	                            verticalAlignment: VerticalAlignment.Center
	                        }
	                    }
	                    visible: _dialplan.matchType>0
	                }
	                
	                Container {
	                    layout: StackLayout {
	                        orientation: LayoutOrientation.TopToBottom
	                    }
	                    bottomPadding: 30
	                    bottomMargin: 30
	                    Label {
	                        topMargin: 2
	                        text: qsTr("Transformation:")
	                        textStyle.base: SystemDefaults.TextStyles.SmallText
	                        textStyle.textAlign: TextAlign.Left
	                        horizontalAlignment: HorizontalAlignment.Left
	                        verticalAlignment: VerticalAlignment.Center
	                        bottomMargin: 2
	                    }
	                    Container {
	                        layout: StackLayout {
	                            orientation: LayoutOrientation.LeftToRight
	                        }
	                        
	                        topMargin: 2
	                        DropDown {
	                            layoutProperties: StackLayoutProperties {
	                                spaceQuota: 1.0
	                            }
	                            id: actionDropBox
	                            Option {
	                                text: qsTr("No transformation")
	                                value: 0
	                                selected: _dialplan.actionType == 0
	                            }
	                            Option {
	                                text: matchDropBox.selectedValue == 2? qsTr("Replace prefix:") : qsTr("Replace number:")
	                                value: 1
	                                selected: _dialplan.actionType == 1
	                            }
	                            Option {
	                                text: qsTr("Add prefix:")
	                                value: 2
	                                selected: _dialplan.actionType == 2
	                            }
	                            Option {
	                                text: qsTr("Remove prefix")
	                                value: 3
	                                selected: _dialplan.actionType == 3
	                                enabled: _dialplan.matchType==2
	                            }
	                            
	                            onSelectedOptionChanged: _dialplan.actionType = selectedOption.value
	                            verticalAlignment: VerticalAlignment.Center
	                        }
	                        TextField {
	                            inputMode: TextFieldInputMode.Text
	                            text: _dialplan.actionValue
	                            hintText: actionDropBox.selectedValue==2? qsTr("Replace prefix to") : qsTr("Replace number to")
	                            layoutProperties: StackLayoutProperties {
	                                spaceQuota: 1.0
	                            }
	                            onTextChanging: {
	                                _dialplan.actionValue = text
	                            }
	                            verticalAlignment: VerticalAlignment.Center
	                            visible: actionDropBox.selectedValue==2 || actionDropBox.selectedValue==1
	                        }
	                    }
	                }
	                
	                DropDown {
	                    title: "Sip Account:"
	                    id: sipAccountDropBox
	                    onSelectedValueChanged: {
	                        _dialplan.accountID=selectedValue
	                    }
	                }
	            }
	        }
        }
    }
}