import bb.cascades 1.0

NavigationPane {
    id: navigationPane
    objectName: "navigationPane"

    // Add the application menu using a MenuDefinition

    attachedObjects: [
        ComponentDefinition {
            id: activeCallSheet
            source: "ActiveCall.qml"
        },
        ComponentDefinition {
            id: accountEditor
            source: "AccountEditor.qml"
        },
        ComponentDefinition {
            id: settingsEditor
            source: "SettingEditor.qml"
        },
        ComponentDefinition {
            id: optionsSelector
            source: "OptionsSelector.qml"
        }
    ]

    Page {
        onCreationCompleted: {
            phoneNumberText.requestFocus();
        }
        actions: [
            // define the actions for first tab here
            ActionItem {
                title: qsTr("Contacts(Phone)")
                ActionBar.placement: ActionBarPlacement.OnBar
                imageSource: "icons/icon_186.png"
                onTriggered: {
                    _sipPhone.searchContact(true);
                }
            },
            ActionItem {
                title: qsTr("Contacts(Email)")
                ActionBar.placement: ActionBarPlacement.OnBar
                imageSource: "icons/icon_186.png"
                onTriggered: {
                    _sipPhone.searchContact(true);
                }
            },
            ActionItem {
                title: qsTr("Enter URI")
                ActionBar.placement: ActionBarPlacement.OnBar
                imageSource: "icons/icon_186.png"
                onTriggered: {
                    _sipPhone.searchContact(true);
                }
            }
        ]

        Container {
            layout: StackLayout {
                orientation: LayoutOrientation.TopToBottom
            }
            Container {
                id: dialPadSubTab
                layout: AbsoluteLayout {
                }
                onCreationCompleted: {
                    phoneNumberText.requestFocus();
                }
                preferredWidth: 720

                property int offset: 86
                Divider {
                }
                TextField {
                    hintText: ""
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 0
                        positionY: 0
                    }
                    preferredWidth: 720
                    preferredHeight: 76
                    inputMode: TextFieldInputMode.PhoneNumber
                    textStyle.fontSize: FontSize.XXLarge
                    backgroundVisible: false
                    enabled: true
                    text: ""
                    input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboardOff | TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff
                    textStyle.fontStyle: FontStyle.Normal
                    textStyle.fontWeight: FontWeight.W600
                    //textStyle.color: Color.Green
                    id: phoneNumberText
                    maxHeight: 76.0
                    minHeight: 76.0
                    textStyle.fontSizeValue: 72.0
                    input.submitKey: SubmitKey.Connect
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 0
                        positionY: dialPadSubTab.offset
                    }
                    defaultImageSource: "asset:///buttons/1.png"
                    pressedImageSource: "asset:///buttons/1.png"
                    focusPolicy: FocusPolicy.None
                    onClicked: {
                        //dialPadSubTab.appendDigt("1");
                        //phoneNumberText.text=phoneNumberText.text+1
                        phoneNumberText.text = phoneNumberText.text + "1";
                        phoneNumberText.requestFocus();
                    }
                    /*
                     * shortcuts: [
                     * Shortcut {
                     * key: qsTr("1")
                     * onTriggered: {
                     * phoneNumberText.text=phoneNumberText.text+1
                     * }
                     * },
                     * Shortcut {
                     * key: qsTr("w")
                     * onTriggered: {
                     * phoneNumberText.text=phoneNumberText.text+1
                     * }
                     * }
                     * ]
                     */
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 241
                        positionY: dialPadSubTab.offset
                    }
                    defaultImageSource: "asset:///buttons/2.png"
                    pressedImageSource: "asset:///buttons/2.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 482
                        positionY: dialPadSubTab.offset
                    }
                    defaultImageSource: "asset:///buttons/3.png"
                    pressedImageSource: "asset:///buttons/3.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 0
                        positionY: dialPadSubTab.offset + 96
                    }
                    defaultImageSource: "asset:///buttons/4.png"
                    pressedImageSource: "asset:///buttons/4pressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 241
                        positionY: dialPadSubTab.offset + 96
                    }
                    defaultImageSource: "asset:///buttons/5.png"
                    pressedImageSource: "asset:///buttons/5pressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 482
                        positionY: dialPadSubTab.offset + 96
                    }
                    defaultImageSource: "asset:///buttons/6.png"
                    pressedImageSource: "asset:///buttons/6pressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 0
                        positionY: dialPadSubTab.offset + 190
                    }
                    defaultImageSource: "asset:///buttons/7.png"
                    pressedImageSource: "asset:///buttons/7pressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 241
                        positionY: dialPadSubTab.offset + 190
                    }
                    defaultImageSource: "asset:///buttons/8.png"
                    pressedImageSource: "asset:///buttons/8pressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 482
                        positionY: dialPadSubTab.offset + 190
                    }
                    defaultImageSource: "asset:///buttons/9.png"
                    pressedImageSource: "asset:///buttons/9pressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 0
                        positionY: dialPadSubTab.offset + 285
                    }
                    defaultImageSource: "asset:///buttons/star.png"
                    pressedImageSource: "asset:///buttons/starpressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 241
                        positionY: dialPadSubTab.offset + 285
                    }
                    defaultImageSource: "asset:///buttons/0.png"
                    pressedImageSource: "asset:///buttons/0pressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 482
                        positionY: dialPadSubTab.offset + 285
                    }
                    defaultImageSource: "asset:///buttons/pound.png"
                    pressedImageSource: "asset:///buttons/poundpressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 0
                        positionY: dialPadSubTab.offset + 379
                    }
                    defaultImageSource: "asset:///buttons/call.png"
                    pressedImageSource: "asset:///buttons/callpressed.png"
                }
                ImageButton {
                    layoutProperties: AbsoluteLayoutProperties {
                        positionX: 482
                        positionY: dialPadSubTab.offset + 379
                    }
                    defaultImageSource: "asset:///buttons/backspace.png"
                    pressedImageSource: "asset:///buttons/backspacpressed.png"
                }
            }
            Label {
                text: "It is Z10"
            }
        }
    }
}
