import bb.cascades 1.0
import bb.system 1.0

Page {
    attachedObjects: [
        ComponentDefinition {
            id: editDialPlan
            source: "EditDialplan.qml"
        },
        ComponentDefinition {
            id: testDialPlan
            source: "TestDialPlan.qml"
        }
    ]
    
    actions: [
        // define the actions for first tab here
        ActionItem {
            title: qsTr("Add Entry")
            ActionBar.placement: ActionBarPlacement.OnBar
            imageSource: "icons/plus.png"
            onTriggered: {
                _dialplan.startAddingNew();
                editDialPlan.createObject().open();
            }
        },
        ActionItem {
            title: qsTr("Test Dialplan")
            ActionBar.placement: ActionBarPlacement.OnBar
            imageSource: "icons/large/testdialplan.png"
            onTriggered: {
                _dialplan.startDialplanTest();
                _sipPhone.activeNavigationPane.push(testDialPlan.createObject());
            }
        }
   ]
   titleBar: TitleBar {
        title: qsTr("Dialplan")
    }
    
    actionBarVisibility: ChromeVisibility.Visible
    Container {
        layout: StackLayout {
            orientation: LayoutOrientation.TopToBottom
        }
        Container {
            layout: DockLayout {
            }
            verticalAlignment: VerticalAlignment.Center

            Container {
                leftPadding: 10
                rightPadding: 10
                topPadding: 0
                bottomPadding: 0
                id: historySubTab

                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                ListView {
                    id: dialplanListView
                    dataModel: _dialplan.dataModel

                    signal deleteDialplan(string entryID)
                    signal editDialplan(string entryID)

                    listItemComponents: [
                        ListItemComponent {
                            type: "header"
                            Label {
                                visible: false
                            }
                        },
                        ListItemComponent {
                            type: "item"

                            StandardListItem {
                                id: dpItem
                                title: ListItemData.Title
                                status: ListItemData.Status
                                description: "acc:"+ListItemData.AccountName
                                imageSource: ListItemData.AccountName=="Default"?"icons/large/icon_253.png":"icons/large/icon_254.png"
                                
                                contextActions: [
                                    // Add a set of four actions to the context menu for
                                    // a list item
                                    ActionSet {
                                        ActionItem {
                                            title: qsTr ("Edit") 
                                            imageSource: "asset:///icons/025_Pencil.png"
                                            
                                            onTriggered: {
                                                dpItem.ListItem.view.editDialplan(ListItemData.ID);
                                            }
                                        }
                                        DeleteActionItem {
                                            enabled: ListItemData.ID!="CatchAll"
                                            attachedObjects: [
                                                SystemDialog {
                                                    id: myQmlDialog
                                                    title: qsTr("Warning")
                                                    body: qsTr ("Are you sure you want to delete entry?")
                                                    onFinished: {
                                                        if (myQmlDialog.result ==
                                                        SystemUiResult. ConfirmButtonSelection)
                                                            dpItem.ListItem.view.deleteDialplan(ListItemData.ID)
                                                    }
                                                }
                                            ]
                                            onTriggered: {
                                                myQmlDialog.show();
                                            }
                                        }

                                    } // end of ActionSet
                                ]
                            }
                        }
                    ]

                    onDeleteDialplan: {
                        _dialplan.deleteDialplan(entryID);
                    }
                    onEditDialplan: {
                        _dialplan.startEditting(entryID)
                        editDialPlan.createObject().open();
                    }


                    onTriggered: {
                        clearSelection()
                        select(indexPath)
                        _dialplan.startEditting(_dialplan.dataModel.data(indexPath).ID)
                        editDialPlan.createObject().open();
                        clearSelection()
                    }
                }
            }
        }
    }
}