import bb.cascades 1.0

Page {
    titleBar: TitleBar {
        id: pageTitleBar
        title: "Call Details"
    }
    Container {
        ScrollView {
            scrollViewProperties.scrollMode: ScrollMode.Vertical

            leftMargin: 12.0
            topMargin: 10.0
            rightMargin: 12.0
            bottomMargin: 10.0

            Container {
                layout: StackLayout {
                    orientation: LayoutOrientation.TopToBottom
                }
                Container {
	                layout: StackLayout {
	                    orientation: LayoutOrientation.TopToBottom
	                }
	                id: cont
	                property double scale1: 0.85
	                property double scale2: 1.15
                    leftMargin: 12.0
                    topMargin: 8.0
                    rightMargin: 12.0
                    bottomMargin: 8.0
                    Label {
	                    text: qsTr("General info:")
	                    textStyle.color: Color.Blue
	                    textStyle.textAlign: TextAlign.Center
	                    horizontalAlignment: HorizontalAlignment.Center
                        textStyle.fontSizeValue: 0.0
                        textStyle.fontSize: FontSize.Default
                    }
	
                    Container {
                        layout: StackLayout {
                            orientation: LayoutOrientation.LeftToRight
                        }
                        horizontalAlignment: HorizontalAlignment.Fill
                        Label {
                            text: qsTr("Account:")
                            layoutProperties: StackLayoutProperties {spaceQuota: cont.scale1}
                            verticalAlignment: VerticalAlignment.Center
                            textStyle.textAlign: TextAlign.Right
                        }
                        Label {
                            layoutProperties: StackLayoutProperties {
                                spaceQuota: cont.scale2
                            }
                            verticalAlignment: VerticalAlignment.Center
                            textStyle.textAlign: TextAlign.Left
                            text: _callInfo.getCallData("accountTitle")
                        }
                    }
                    Container {
                        layout: StackLayout {
                            orientation: LayoutOrientation.LeftToRight
                        }
                        horizontalAlignment: HorizontalAlignment.Fill
                        Label {
                            text: qsTr("Phone/address:")
                            layoutProperties: StackLayoutProperties {spaceQuota: cont.scale1}
                            verticalAlignment: VerticalAlignment.Center
                            textStyle.textAlign: TextAlign.Right
                        }
                        Label {
                            layoutProperties: StackLayoutProperties {
                                spaceQuota: cont.scale2
                            }
                            verticalAlignment: VerticalAlignment.Center
                            textStyle.textAlign: TextAlign.Left
                            text: _callInfo.getCallData("address")
                        }
                    }
	                Container {
	                    layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	                    Label {
	                        layoutProperties: StackLayoutProperties {
	                            spaceQuota: cont.scale1
	                        }
	                        verticalAlignment: VerticalAlignment.Center
	                        textStyle.textAlign: TextAlign.Right
	                        text: qsTr("Name:")
	                        horizontalAlignment: HorizontalAlignment.Right
	                    }
	                    Label {
	                        layoutProperties: StackLayoutProperties {
	                            spaceQuota: cont.scale2
	                        }
	                        verticalAlignment: VerticalAlignment.Center
	                        textStyle.textAlign: TextAlign.Left
	                        text: _callInfo.getCallData("name")
	                    }
	                }
	                Container {
	                    layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	                    Label {
	                        layoutProperties: StackLayoutProperties {
	                            spaceQuota: cont.scale1
	                        }
	                        verticalAlignment: VerticalAlignment.Center
	                        textStyle.textAlign: TextAlign.Right
	                        text: qsTr("Date:")
	                    }
	                    Label {
	                        layoutProperties: StackLayoutProperties {
	                            spaceQuota: cont.scale2
	                        }
	                        verticalAlignment: VerticalAlignment.Center
	                        textStyle.textAlign: TextAlign.Left
	                        text: _callInfo.getCallData("callTime")
	                    }
	                }
	                Container {
	                    layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	                    Label {
	                        layoutProperties: StackLayoutProperties {
	                            spaceQuota: cont.scale1
	                        }
	                        verticalAlignment: VerticalAlignment.Center
	                        textStyle.textAlign: TextAlign.Right
	                        text: qsTr("Duration:")
	                    }
	                    Label {
	                        layoutProperties: StackLayoutProperties {
	                            spaceQuota: cont.scale2
	                        }
	                        verticalAlignment: VerticalAlignment.Center
	                        textStyle.textAlign: TextAlign.Left
	                        text: _callInfo.getCallData("durSec")
	                    }
	                }
	            }

                Container {
                    layout: StackLayout {
                        orientation: LayoutOrientation.TopToBottom
                    }
                    visible: _callInfo.hasAudioData()
                    id: cont1
                    property int scale1: 1
                    property int scale2: 1
                    Divider {

                    }
                    Label {
                        text: qsTr("Meda info:")
                        textStyle.fontSize: FontSize.Default
                        textStyle.color: Color.Blue
                        textStyle.textAlign: TextAlign.Center
                        horizontalAlignment: HorizontalAlignment.Fill
                    }
                    Container {
	                    layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	                    horizontalAlignment: HorizontalAlignment.Fill
	                    Label {
	                        text: qsTr("Media codec:")
	                        layoutProperties: StackLayoutProperties {
	                            spaceQuota: cont.scale1
	                        }
	                        verticalAlignment: VerticalAlignment.Center
	                        textStyle.textAlign: TextAlign.Right
	                    }
	                    Label {
	                        layoutProperties: StackLayoutProperties {
	                            spaceQuota: cont.scale2
	                        }
	                        verticalAlignment: VerticalAlignment.Center
	                        textStyle.textAlign: TextAlign.Left
	                        text: _callInfo.getCallAudioData("codec")
	                    }
                    }
                    Container {
                        layout: StackLayout {
                            orientation: LayoutOrientation.TopToBottom
                        }
                        id: cont3
                        property int scale1: 2
                        property int scale2: 1
                        property int scale3: 1
                        leftMargin: 12.0
                        topMargin: 10.0
                        rightMargin: 12.0
                        bottomMargin: 10.0
                        Divider {

                        }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: ""
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                text: qsTr("Tx")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                            Label {
                                text: qsTr("Rx")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale3
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                        }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: qsTr("Bytes:")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.tx.bytes")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.rx.bytes")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale3
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                        }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: qsTr("Packets:")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.tx.pkt")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.rx.pkt")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale3
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                        }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: qsTr("Discarded packets:")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.tx.discard")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.rx.discard")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale3
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                        }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: qsTr("Duplicated packets:")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.tx.dup")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.rx.dup")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale3
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                        }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: qsTr("Lost packets:")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.tx.loss")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.rx.loss")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale3
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                        }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: qsTr("Out of order packets:")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.tx.reorder")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                            Label {
                                text: _callInfo.getCallAudioData("rtcp_stat.rx.reorder")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont3.scale3
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                            }
                        }
                    }
                    Container {
                        layout: StackLayout {
                            orientation: LayoutOrientation.TopToBottom
                        }
                        visible: _callInfo.getCallAudioData("rtcp_stat.rtt.n")>0
                        id: cont2
                        property int scale1: 1
                        property int scale2: 1
                        topMargin: 8.0
                        bottomMargin: 8.0
                        Divider {

                        }
                        Label {
	                        text: qsTr("Round Trip Time(RTT):")
	                        textStyle.fontSize: FontSize.Small
	                        textStyle.color: Color.Blue
	                        textStyle.textAlign: TextAlign.Center
	                        horizontalAlignment: HorizontalAlignment.Fill
	                    }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: qsTr("Number of samples:")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont2.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont2.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                                text: _callInfo.getCallAudioData("rtcp_stat.rtt.n")
                            }
                        }
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Fill
                            Label {
                                text: qsTr("Max(msec):")
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont2.scale1
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Right
                            }
                            Label {
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: cont2.scale2
                                }
                                verticalAlignment: VerticalAlignment.Center
                                textStyle.textAlign: TextAlign.Left
                                text: _callInfo.getCallAudioData("rtcp_stat.rtt.max") / 1000
                            }
                        }
	                    Container {
	                        layout: StackLayout {
	                            orientation: LayoutOrientation.LeftToRight
	                        }
	                        horizontalAlignment: HorizontalAlignment.Fill
	                        Label {
	                            text: qsTr("Min(msec):")
	                            layoutProperties: StackLayoutProperties {
	                                spaceQuota: cont2.scale1
	                            }
	                            verticalAlignment: VerticalAlignment.Center
	                            textStyle.textAlign: TextAlign.Right
	                        }
	                        Label {
	                            layoutProperties: StackLayoutProperties {
	                                spaceQuota: cont2.scale2
	                            }
	                            verticalAlignment: VerticalAlignment.Center
	                            textStyle.textAlign: TextAlign.Left
	                            text: _callInfo.getCallAudioData("rtcp_stat.rtt.min") / 1000
	                        }
	                    }
	                    Container {
	                        layout: StackLayout {
	                            orientation: LayoutOrientation.LeftToRight
	                        }
	                        horizontalAlignment: HorizontalAlignment.Fill
	                        Label {
	                            text: qsTr("Mean(msec):")
	                            layoutProperties: StackLayoutProperties {
	                                spaceQuota: cont2.scale1
	                            }
	                            verticalAlignment: VerticalAlignment.Center
	                            textStyle.textAlign: TextAlign.Right
	                        }
	                        Label {
	                            layoutProperties: StackLayoutProperties {
	                                spaceQuota: cont2.scale2
	                            }
	                            verticalAlignment: VerticalAlignment.Center
	                            textStyle.textAlign: TextAlign.Left
	                            text: _callInfo.getCallAudioData("rtcp_stat.rtt.mean") / 1000
	                        }
	                    }
                     }
                }
            }
        }
    }
}
