import bb.cascades 1.0

Page {
    id: root

    titleBar: TitleBar {
        id: pageTitleBar
        title: "Authentication settings"
    }

    Container {
        layout: DockLayout {}

        // The background image
        ImageView {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            //imageSource: "asset:///images/background.png"
        }

        Container {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            leftPadding: 30
            topPadding: 30
            rightPadding: 30

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1
	                }	
		            text: qsTr("Realm:")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	            TextField {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
	                id: realmField
                    input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
	
	                hintText: qsTr ("Enter realm or * (for any)")
	                text: _sipPhone.sipRealm
	                onTextChanging: _sipPhone.sipRealm = text
	            }
	        }

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1
	                }	
		            text: qsTr("Auth user name:")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	            TextArea {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
	                id: authUserNameField
                    input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
		
	                hintText: qsTr ("will use username if empty")
	                text: _sipPhone.sipAuthUserName
	                onTextChanging: _sipPhone.sipAuthUserName = text
	            }
	        }
        }
    }
}