import bb.cascades 1.0

Sheet {
    id: sheet
    content: Page {
        id: notifySettingsPage

        titleBar: TitleBar {
            id: pageTitleBar
            title: "Audio Codecs"

            // The 'Create/Save' action
            acceptAction: ActionItem {
                title: (qsTr("Save"))

                onTriggered: {
                    _audioCodecsManager.saveCfg();
                    _sipPhone.applyCodecs();
                    sheet.close();
                }
            }

            // The 'Cancel' action
            dismissAction: ActionItem {
                title: qsTr("Cancel")

                onTriggered: {
                    _audioCodecsManager.cancelEditting();
                    sheet.close();
                }
            }
        }

        
        Container {
            SegmentedControl {
                id: segmentedControl
                Option {
                    id: wifiOption
                    text: "WiFi"
                    value: "0"
                    selected: true
                }
                Option {
                    id: cellOption
                    text: "Cell"
                    value: "1"
                }
                onSelectedIndexChanged: {
                    var value = segmentedControl.selectedValue;
                    _audioCodecsManager.setCfgType(parseInt(value));
                }
            }
            
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill
            ListView {
                id: optionsListView
                dataModel: _audioCodecsManager.dataModel
                signal enableCodec(string codecName)
                signal disableCodec(string codecName)
                signal moveUp(string codecName)
                signal moveDown(string codecName)
                signal moveTop(string codecName)
                signal moveBottom(string codecName)
                
                onEnableCodec: {
                    _audioCodecsManager.enableCodec(codecName)
                }
                onDisableCodec: {
                    _audioCodecsManager.disableCodec(codecName)
                }
                onMoveUp: {
                    _audioCodecsManager.moveCodecUp(codecName)
                }
                onMoveDown: {
                    _audioCodecsManager.moveCodecDown(codecName)
                }
                onMoveTop: {
                    _audioCodecsManager.moveCodecTop(codecName)
                }
                onMoveBottom: {
                    _audioCodecsManager.moveCodecBottom(codecName)
                }

                listItemComponents: [
                    ListItemComponent {
                        type: "header"
                        Header {
                            title: ListItemData==1?"Enabled codecs":"Available codecs"

                            // Apply a text style to create a large, bold font with
                            // a specific color
                            //textStyle {
                            //    base: SystemDefaults.TextStyles.BigText
                            //    fontWeight: FontWeight.Bold
                            //    color: Color.create("#7a184a")
                            //}
                        }
                    },
                    ListItemComponent {
                        type: "item"

                        Container {
                            id: codecItem
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            topMargin: 8
                            bottomMargin: 8
                            CheckBox {
                                checked: ListItemData.enabled == 1
                                text: ""//ListItemData.name
                                onCheckedChanged: {
                                    if (checked) codecItem.ListItem.view.enableCodec(ListItemData.name);
                                    else codecItem.ListItem.view.disableCodec(ListItemData.name);
                                }
                                horizontalAlignment: HorizontalAlignment.Left
                                verticalAlignment: VerticalAlignment.Center
                            }
                            Label {
                            	text: ListItemData.name;//+"("+ ListItemData.order+")"
                                verticalAlignment: VerticalAlignment.Center
                                horizontalAlignment: HorizontalAlignment.Fill
                                layoutProperties: StackLayoutProperties {
                                    spaceQuota: 2.0

                                }
                                textStyle.fontSize: FontSize.Large
                            }
                            Container {
                                layout: AbsoluteLayout {
                                }
                                ImageButton {
                                    layoutProperties: AbsoluteLayoutProperties {
                                        positionX: 4.0
                                        positionY: 4.0
                                    }

                                    defaultImageSource: "icons/codec_up.png"
                                    pressedImageSource: "icons/codec_up.png"
                                    horizontalAlignment: HorizontalAlignment.Right
                                    visible: ListItemData.enabled
                                    onClicked: {
                                        codecItem.ListItem.view.moveUp(ListItemData.name)
                                    }
                                }
                                ImageButton {
                                    layoutProperties: AbsoluteLayoutProperties {
                                        positionX: 89.0
                                        positionY: 4.0
                                    }
                                    defaultImageSource: "icons/codec_down.png"
	                                pressedImageSource: "icons/codec_down.png"
	                                horizontalAlignment: HorizontalAlignment.Right
	                                visible: ListItemData.enabled
	                                onClicked: {
	                                    codecItem.ListItem.view.moveDown(ListItemData.name)
	                                }
	                            }
	                            ImageButton {
                                    layoutProperties: AbsoluteLayoutProperties {
                                        positionX: 174.0
                                        positionY: 4.0
                                    }
                                    defaultImageSource: "icons/codec_top.png"
	                                pressedImageSource: "icons/codec_top.png"
	                                horizontalAlignment: HorizontalAlignment.Right
	                                visible: ListItemData.enabled
	                                onClicked: {
	                                    codecItem.ListItem.view.moveTop(ListItemData.name)
	                                }
	                            }
	                            ImageButton {
                                    layoutProperties: AbsoluteLayoutProperties {
                                        positionX: 259.0
                                        positionY: 4.0
                                    }
                                    defaultImageSource: "icons/codec_bottom.png"
                                    pressedImageSource: "icons/codec_bottom.png"
                                    horizontalAlignment: HorizontalAlignment.Right
	                                visible: ListItemData.enabled
	                                onClicked: {
	                                    codecItem.ListItem.view.moveBottom(ListItemData.name)
	                                }
	                            }
	                        }
                        }
                    }
                ]
            }
        }
    }
}
