import bb.cascades 1.0

Page {
    id: root

    titleBar: TitleBar {
        id: pageTitleBar
        title: "Advanced account settings"
    }

    Container {
        layout: DockLayout {}

        Container {
            horizontalAlignment: HorizontalAlignment.Fill
            verticalAlignment: VerticalAlignment.Fill

            leftPadding: 30
            topPadding: 30
            rightPadding: 30

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1
	                }	
		            text: qsTr("Display name:")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	            TextArea {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
                    input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
		
	                hintText: qsTr ("Your name (Optional)")
	                text: _sipPhone.sipDisplayName
	                onTextChanging: _sipPhone.sipDisplayName = text
	            }
	        }

            Container {
	            layout: StackLayout {
	                        orientation: LayoutOrientation.LeftToRight
	                    }
	            topPadding: 30
		        Label {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 1
	                }	
		            text: qsTr("Outbound Proxy:")
		            textStyle.base: SystemDefaults.TextStyles.SubtitleText
		            textStyle.textAlign: TextAlign.Right
		            horizontalAlignment: HorizontalAlignment.Right
		            verticalAlignment: VerticalAlignment.Center
		        }
	            TextArea {
	                layoutProperties: StackLayoutProperties {
	                     spaceQuota: 2
	                }	
	                id: proxyField
	
	                hintText: qsTr ("domain[:port] (Optional)")
	
	                text:_sipPhone.sipProxy
	                onTextChanging: _sipPhone.sipProxy = text
                    input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
                }
	        }
            
            
            Container {
                layout: StackLayout {
                    orientation: LayoutOrientation.LeftToRight
                }
                topPadding: 30
                DropDown {
                    layoutProperties: StackLayoutProperties {
                        spaceQuota: 2
                    }	
                    objectName: "transportDropDown"
                    verticalAlignment: VerticalAlignment.Center
                    horizontalAlignment: HorizontalAlignment.Left
                    title: "Transport"
                    
                    Option {
                        text: "UDP"
                        selected: _sipPhone.transport==1 
                        value: "1"
                    }
                    Option {
                        text: "TCP"
                        selected: _sipPhone.transport==2
                        value: "2"
                    }
                    
                    onSelectedOptionChanged: _sipPhone.transport=parseInt(selectedOption.value)
                }
            }
        }
    }
}