import bb.cascades 1.0

Sheet {
    id: activeCallSheet
    objectName: "activeCallSheet"
    
    onCreationCompleted: {
        _sipPhone.activeCallStatusChanged.connect(onActiveCallStatusChanged);
    }
    function onActiveCallStatusChanged() {
        if (_sipPhone.activeCallStatus==0){
            activeCallSheet.close();
        }
    }

    Page {
	    Container {
	        layout: DockLayout {}
	        verticalAlignment: VerticalAlignment.Center
	        visible: (!_sipPhone.proximityOn)
	
	        // The background image
	        ImageView {
	            horizontalAlignment: HorizontalAlignment.Fill
	            verticalAlignment: VerticalAlignment.Fill
	
	            //imageSource: "asset:///images/background.png"
	        }

			Container {
       			preferredHeight: 70
       		}
	        Container {
	            horizontalAlignment: HorizontalAlignment.Fill
	            verticalAlignment: VerticalAlignment.Fill
	            leftPadding: 20
	            topPadding: 20
	            rightPadding: 20
	            
		        Label {
		            text: (incomingCallPhoto.visible || _sipPhone.dtmfBuffer.length==0)?(_sipPhone.callerName==_sipPhone.callerAddress?_sipPhone.callerName:(_sipPhone.callerName+"("+_sipPhone.callerAddress+")")):_sipPhone.dtmfBuffer
		            textStyle.base: SystemDefaults.TextStyles.BodyText;
		            textStyle.textAlign: TextAlign.Center
		            horizontalAlignment: HorizontalAlignment.Center
                    textStyle.fontSize: FontSize.Large
                }
	
		        //Label {
		        //    text: _sipPhone.callerAddress
		        //    textStyle.base: SystemDefaults.TextStyles.BodyText
		        //    textStyle.textAlign: TextAlign.Center
		        //    horizontalAlignment: HorizontalAlignment.Center
	            // }

                Container {
                    preferredHeight: 70
                }
                
                Container { 
		            layout: DockLayout {
		                    }
	                verticalAlignment: VerticalAlignment.Center
	                horizontalAlignment: HorizontalAlignment.Center
	                ImageView {
	                    id: incomingCallPhoto
	                    imageSource: _sipPhone.callerPhoto
	                    topMargin: 12
	                    bottomPadding: 50
	                    preferredHeight: 480
	                    preferredWidth: 480
	                    verticalAlignment: VerticalAlignment.Center
	                    horizontalAlignment: HorizontalAlignment.Center
	                    scalingMethod: ScalingMethod.AspectFit
	                }
		            Container {
		                id: keypadContainer
		                visible: false
			            layout: StackLayout {
			                        orientation: LayoutOrientation.TopToBottom
			            }
	                    preferredHeight: 480
	                    preferredWidth: 720
	                    verticalAlignment: VerticalAlignment.Center
	                    horizontalAlignment: HorizontalAlignment.Center

			            Divider {}				            
                        Label {
		                    id: dtmfEntered
		                    objectName: "dtmfEntered"
		                    verticalAlignment: VerticalAlignment.Center
		                    horizontalAlignment: HorizontalAlignment.Center
		                }
                        Container {
                            id: dialPadSubTab
                            layout: AbsoluteLayout {
                            }
                            onCreationCompleted: {
                                destText.requestFocus();
                            }

                            function digitClicked(digit) {
                                destText.text += digit;
                                destText.requestFocus();
                                if (digitSoundOn.checked) {
                                    beepSound.play();
                                }
                            }

                            horizontalAlignment: HorizontalAlignment.Fill

                            property int offset: 0
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 0
                                    positionY: dialPadSubTab.offset
                                }
                                defaultImageSource: "asset:///buttons/1.png"
                                pressedImageSource: "asset:///buttons/1pressed.png"
                                focusPolicy: FocusPolicy.None
                                onClicked: {
                                    _sipPhone.dtmfEntered("1");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 241
                                    positionY: dialPadSubTab.offset
                                }
                                defaultImageSource: "asset:///buttons/2.png"
                                pressedImageSource: "asset:///buttons/2pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("2");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 482
                                    positionY: dialPadSubTab.offset
                                }
                                defaultImageSource: "asset:///buttons/3.png"
                                pressedImageSource: "asset:///buttons/3pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("3");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 0
                                    positionY: dialPadSubTab.offset + 96
                                }
                                defaultImageSource: "asset:///buttons/4.png"
                                pressedImageSource: "asset:///buttons/4pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("4");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 241
                                    positionY: dialPadSubTab.offset + 96
                                }
                                defaultImageSource: "asset:///buttons/5.png"
                                pressedImageSource: "asset:///buttons/5pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("5");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 482
                                    positionY: dialPadSubTab.offset + 96
                                }
                                defaultImageSource: "asset:///buttons/6.png"
                                pressedImageSource: "asset:///buttons/6pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("6");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 0
                                    positionY: dialPadSubTab.offset + 190
                                }
                                defaultImageSource: "asset:///buttons/7.png"
                                pressedImageSource: "asset:///buttons/7pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("7");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 241
                                    positionY: dialPadSubTab.offset + 190
                                }
                                defaultImageSource: "asset:///buttons/8.png"
                                pressedImageSource: "asset:///buttons/8pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("8");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 482
                                    positionY: dialPadSubTab.offset + 190
                                }
                                defaultImageSource: "asset:///buttons/9.png"
                                pressedImageSource: "asset:///buttons/9pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("9");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 0
                                    positionY: dialPadSubTab.offset + 285
                                }
                                defaultImageSource: "asset:///buttons/star.png"
                                pressedImageSource: "asset:///buttons/starpressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("*");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 241
                                    positionY: dialPadSubTab.offset + 285
                                }
                                defaultImageSource: "asset:///buttons/0.png"
                                pressedImageSource: "asset:///buttons/0pressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("0");
                                }
                            }
                            ImageButton {
                                layoutProperties: AbsoluteLayoutProperties {
                                    positionX: 482
                                    positionY: dialPadSubTab.offset + 285
                                }
                                defaultImageSource: "asset:///buttons/pound.png"
                                pressedImageSource: "asset:///buttons/poundpressed.png"
                                onClicked: {
                                    _sipPhone.dtmfEntered("#");
                                }
                            }
		                }
		            }
	            }

                Container {
                    preferredHeight: 100
                }
                
                Container {
		            layout: DockLayout {
		                    }
			         horizontalAlignment: HorizontalAlignment.Center
		             Container {
		                id: incomingCallContainer 
		                objectName: "incomingCallContainer" 
		                visible: _sipPhone.activeCallStatus==1
                        horizontalAlignment: HorizontalAlignment.Center
			            verticalAlignment: VerticalAlignment.Fill
			            layout: StackLayout {
			                        orientation: LayoutOrientation.LeftToRight
			                    }
			             topPadding: 50
					     Button {
				            text: qsTr("Answer")
				            horizontalAlignment: HorizontalAlignment.Center
                            imageSource: "asset:///icons/icon_122.png"
				            onClicked: {
				                _sipPhone.answerCall();
				            }
					     }
					     Button {
				            text: qsTr("Reject")
				            
				            horizontalAlignment: HorizontalAlignment.Center
                            imageSource: "asset:///icons/icon_125.png"
				            onClicked: {
				                _sipPhone.endCall();
				            }
					     }
					 }
					 
		             Container {
		                id: connectedCallContainer
		                objectName: "connectedCallContainer"
                        visible: _sipPhone.activeCallStatus == 3
                        horizontalAlignment: HorizontalAlignment.Center
			            verticalAlignment: VerticalAlignment.Fill
			            layout: StackLayout {
			                        orientation: LayoutOrientation.TopToBottom
			                    }
			            onVisibleChanged: {
		                    keypadContainer.visible=false;
		                    incomingCallPhoto.visible=true;
					        keypadButton.defaultImageSource="asset:///icons/icon_127.png";
			            }
			            
		                Container {
				            horizontalAlignment: HorizontalAlignment.Center
				            verticalAlignment: VerticalAlignment.Top
				            layout: StackLayout {
				                        orientation: LayoutOrientation.LeftToRight
				            }
					        topPadding: 10
						   ImageButton {
						        rightMargin: 80
					            horizontalAlignment: HorizontalAlignment.Center
                                defaultImageSource: _sipPhone.muted?"asset:///icons/icon_185_red.png":"asset:///icons/icon_185.png"
					            onClicked: {
					                _sipPhone.toggleMute();
					            }
					       }
						   ImageButton {
						        leftPadding: 80
						        rightMargin: 80
					            horizontalAlignment: HorizontalAlignment.Center
                                defaultImageSource: _audio.currentDevice==0?"asset:///icons/icon_160_red.png":"asset:///icons/icon_160.png"
					            onClicked: {
					                _sipPhone.toggleSpeaker();
					            }
					       }
						   ImageButton {
						        id: keypadButton
						        leftPadding: 80
						        rightMargin: 80
					            horizontalAlignment: HorizontalAlignment.Center
                                defaultImageSource: "asset:///icons/icon_127.png";
					            onClicked: {
					                //_sipPhone.showDTMFKeypad();
					                if (incomingCallPhoto.visible) {
					                    incomingCallPhoto.visible=false;
					                    keypadContainer.visible=true;
					                    keypadButton.defaultImageSource="asset:///icons/icon_127_red.png";
					                }
					                else {
					                    keypadContainer.visible=false;
					                    incomingCallPhoto.visible=true;
					                    keypadButton.defaultImageSource="asset:///icons/icon_127.png";
					                }
					            }
					       }
					       Label {
					           text:_sipPhone.callDurationStr
                                horizontalAlignment: HorizontalAlignment.Center
                                verticalAlignment: VerticalAlignment.Center;
                                textStyle.fontSize: FontSize.Default
                            }    
		                }
			             
					     Button {
					        topMargin: 60
				            text: qsTr("End Call")
				            
				            horizontalAlignment: HorizontalAlignment.Center
                            imageSource: "asset:///icons/icon_125.png"
				            onClicked: {
				                _sipPhone.endCall();
				            }
					     }
		            }
		             Container {
		                id: outgoingCallContainer
		                objectName: "outgoingCallContainer"
                        visible: _sipPhone.activeCallStatus == 2
                        horizontalAlignment: HorizontalAlignment.Center
			            verticalAlignment: VerticalAlignment.Fill
			            layout: StackLayout {
			                        orientation: LayoutOrientation.TopToBottom
			                    }
		                Container {
				            horizontalAlignment: HorizontalAlignment.Center
				            verticalAlignment: VerticalAlignment.Top
				            layout: StackLayout {
				                        orientation: LayoutOrientation.LeftToRight
				            }
					        topPadding: 10
						    ImageButton {
						        leftPadding: 80
						        rightMargin: 80
					            horizontalAlignment: HorizontalAlignment.Center
                                defaultImageSource: _audio.currentDevice==0?"asset:///icons/icon_160_red.png":"asset:///icons/icon_160.png"
					            onClicked: {
					                _sipPhone.toggleSpeaker();
					            }
					        }
					       Label {
					            text:_sipPhone.callProgressStr
                                horizontalAlignment: HorizontalAlignment.Center
                                verticalAlignment: VerticalAlignment.Center;
                                textStyle.fontSize: FontSize.Default
                            }    
		                 }
					     Button {
					        topMargin: 60
				            text: qsTr("Cancel")
				            
				            horizontalAlignment: HorizontalAlignment.Center
                            imageSource: "asset:///icons/icon_125.png"
				            onClicked: {
				                _sipPhone.endCall();
				            }
					     }
		            }
	            }
            }
        }
    }
}
