import bb.cascades 1.0
import bb.system 1.0

Page {
    id: accountsPage
    attachedObjects: [
        ComponentDefinition {
            id: accountEditor
            source: "AccountEditor.qml"
        }
    ]

    actions: [
        // define the actions for first tab here
        ActionItem {
            title: qsTr("Add Account")
            ActionBar.placement: ActionBarPlacement.OnBar
            imageSource: "icons/plus.png"
            enabled: _sipPhone.addingAccountAllowed
            onTriggered: {
                _sipPhone.enterAddingAccount();
                accountEditor.createObject().open();
            }
        },
        // define the actions for first tab here
        ActionItem {
            title: qsTr("Ping Servicce")
            ActionBar.placement: ActionBarPlacement.InOverflow
            imageSource: "icons/230_Megaphone.png"
            onTriggered: {
                _invController.pingService();
            }
        },
        ActionItem {
             title: qsTr("Init")
             ActionBar.placement: ActionBarPlacement.InOverflow
             imageSource: "icons/230_Megaphone.png"
             onTriggered: {
                 _sipPhone.enterAddingAccount();
                 _invController.initService();
             }
        },
        ActionItem {
             title: qsTr("UnInit")
             ActionBar.placement: ActionBarPlacement.InOverflow
             imageSource: "icons/230_Megaphone.png"
             onTriggered: {
                 _sipPhone.enterAddingAccount();
                 _invController.uninitService();
             }
        },
        ActionItem {
             title: qsTr("ReStart UI stack")
             ActionBar.placement: ActionBarPlacement.InOverflow
             imageSource: "icons/230_Megaphone.png"
             onTriggered: {
                 _sipPhone.restartStack();
             }
        }
    ]
    titleBar: TitleBar {
        title: qsTr ("SIP Accounts")
    }
    Container {
        layout: DockLayout {
        }
        verticalAlignment: VerticalAlignment.Fill
        horizontalAlignment: HorizontalAlignment.Fill
        
        Container {
            visible: _sipPhone.hasAccounts==false
            verticalAlignment: VerticalAlignment.Center
            horizontalAlignment: HorizontalAlignment.Center
            Container {
                preferredHeight: 20.0
            }
            Label {
                text:qsTr ("To start using sip.fm you need to configure")
                textStyle.textAlign: TextAlign.Center
                horizontalAlignment: HorizontalAlignment.Center
            }
            Label {
                text:qsTr ("your SIP account first")
                textStyle.textAlign: TextAlign.Center
                horizontalAlignment: HorizontalAlignment.Center
            }
            Button {
                horizontalAlignment: HorizontalAlignment.Center
                text:qsTr ("Add account")
                onClicked: {
                    _sipPhone.enterAddingAccount();
                    accountEditor.createObject().open();
                }
            }
        }
        Container {
            visible: _sipPhone.hasAccounts
            
            ListView {
                
                id: accountsListView
                dataModel: _sipPhone.accountsDataModel
                signal editAccount(string accountID)
                signal deleteAccount(string accountID)
                
                listItemComponents : [ 
	                ListItemComponent {
	                    type: "header"
	                    id: headerItem
	                    Header {
	                        title: ListItemData
	                    }
	                }, 
                    ListItemComponent {
	                    type: "item"
	                    
	                    StandardListItem {
	                        id: accountItem
	                        title: ListItemData.name
	                        description: ListItemData.descr
	                        status: ListItemData.status;
	                        imageSource: ListItemData.icon
	                        contextActions: [
	                            // Add a set of four actions to the context menu for
	                            // a list item
	                            
	                            ActionSet {
	                                ActionItem {
	                                    title: qsTr ("Edit account") 
	                                    imageSource: "asset:///icons/025_Pencil.png"
	                                    
	                                    onTriggered: {
	                                    	accountItem.ListItem.view.editAccount(ListItemData.ID);
	                                    }
	                                }
	                                DeleteActionItem {
	                                    attachedObjects: [
	                                        SystemDialog {
	                                            id: myQmlDialog
	                                            title: qsTr("Warning")
	                                            body: qsTr ("Are you sure you want to delete account?")
	                                            onFinished: {
	                                                if (myQmlDialog.result ==
	                                                SystemUiResult. ConfirmButtonSelection)
	                                                	accountItem.ListItem.view.deleteAccount(ListItemData.ID);
	                                            }
	                                        }
	                                    ]
	                                    onTriggered: {
	                                        myQmlDialog.show();
	                                    }
	                                }
	                            } // end of ActionSet
	                        ]
	                    }
	                }
                ]
                
                onEditAccount: {
                    _sipPhone.enterAccountEditing(accountID);
                    accountEditor.createObject().open();
                }
                onDeleteAccount: {
                    _sipPhone.deleteAccount(accountID);
                }
                
                
                onTriggered: {
                    clearSelection()
                    select(indexPath)
                    
                    _sipPhone.enterAccountEditing(_sipPhone.accountsDataModel.data(indexPath).ID);
                    accountEditor.createObject().open();
                    clearSelection()
                }
            }
        }
    }
}
