import bb.cascades 1.0

Sheet {
    id:sheet
    content: NavigationPane {
	   id: accEditNavigationPane
       objectName: "accEditNavigationPane"
       attachedObjects: [
	       ComponentDefinition {
	                id: advAccountEditor
	                source: "AdvAccountEditor.qml"
	       },    
	       ComponentDefinition {
	                id: authAccountEditor
	                source: "AuthAccountEditor.qml"
	       },    
	       ComponentDefinition {
	                id: regAccountEditor
	                source: "RegAccountEditor.qml"
	       },    
           ComponentDefinition {
               id: natAccountEditor
               source: "NatAccountEditor.qml"
           },    
           ComponentDefinition {
               id: purchaseSheet
               source: "Purchases.qml"
           }    
	    ]   
	   Page {
		    id: accountEditPage
		   
		    titleBar: TitleBar {
		        id: pageTitleBar
		
		        // The 'Create/Save' action
		        acceptAction: ActionItem {
		            title: (qsTr ("Save"))
		
		            onTriggered: {
                        var saveResult=_sipPhone.saveAccount();
		                if (saveResult==1) {
                            _sipPhone.fixSelectedAccount();
		                	sheet.close();
		                } else if (saveResult==2) {
                            purchaseSheet.createObject().open()
		                }
		            }
		        }
		
		        // The 'Cancel' action
		        dismissAction: ActionItem {
		            title: qsTr ("Cancel")
		
		            onTriggered: { 
                        _sipPhone.fixSelectedAccount();
		                sheet.close();
		            }
		        }
		    }
		
		    Container {
		        layout: DockLayout {}
		
		        // The background image
		        ImageView {
		            horizontalAlignment: HorizontalAlignment.Fill
		            verticalAlignment: VerticalAlignment.Fill
		
		            //imageSource: "asset:///images/background.png"
		        }
		
		        Container {
		            horizontalAlignment: HorizontalAlignment.Fill
		            verticalAlignment: VerticalAlignment.Fill
		
		            leftPadding: 30
		            topPadding: 30
		            rightPadding: 30
		
		            Container {
			            layout: StackLayout {
			                        orientation: LayoutOrientation.LeftToRight
			                    }
			            topPadding: 30
				        Label {
			                layoutProperties: StackLayoutProperties {
			                     spaceQuota: 1.7
			                }	
				            text: qsTr("Domain:")
				            textStyle.base: SystemDefaults.TextStyles.BodyText
				            textStyle.textAlign: TextAlign.Right
				            horizontalAlignment: HorizontalAlignment.Right
				            verticalAlignment: VerticalAlignment.Center
				        }
			            TextField {
			                layoutProperties: StackLayoutProperties {
			                     spaceQuota: 2
			                }	
			                id: domainField
			                input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
			
			                hintText: qsTr ("Enter SIP Domian")
			                text: _sipPhone.sipDomain
			                onTextChanging: _sipPhone.sipDomain = text
			            }
			        }
		
		            Container {
			            layout: StackLayout {
			                        orientation: LayoutOrientation.LeftToRight
			                    }
			            topPadding: 30
				        Label {
			                layoutProperties: StackLayoutProperties {
			                     spaceQuota: 1.7
			                }	
				            text: qsTr("User name:")
				            textStyle.base: SystemDefaults.TextStyles.BodyText
				            textStyle.textAlign: TextAlign.Right
				            horizontalAlignment: HorizontalAlignment.Right
				            verticalAlignment: VerticalAlignment.Center
				        }
			            TextField {
			                layoutProperties: StackLayoutProperties {
			                     spaceQuota: 2
			                }	
			                id: userNameField
			                input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
				
			                hintText: qsTr ("Enter SIP User Name")
			                text: _sipPhone.sipUserName
			                onTextChanging: _sipPhone.sipUserName = text
			            }
			        }
		
		            Container {
			            layout: StackLayout {
			                        orientation: LayoutOrientation.LeftToRight
			                    }
			            topPadding: 30
				        Label {
			                layoutProperties: StackLayoutProperties {
			                     spaceQuota: 1.7
			                }	
				            text: _sipPhone.sipPassword.length>0?qsTr("Update password:"): qsTr("Password:")
                            textStyle.base: SystemDefaults.TextStyles.BodyText
				            textStyle.textAlign: TextAlign.Right
				            horizontalAlignment: HorizontalAlignment.Right
				            verticalAlignment: VerticalAlignment.Center
				        }
                        TextField {
			                layoutProperties: StackLayoutProperties {
			                     spaceQuota: 2
			                }	
			                id: passwordField
			                inputMode: TextFieldInputMode.Password
			
			                hintText: qsTr ("Enter password")
			                
			                text: "" //_sipPhone.sipPassword
			                onTextChanging: _sipPhone.sipPassword = text
		                    input.submitKey: SubmitKey.Done
		                    input.masking: TextInputMasking.Masked
			                input.flags: TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard| TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff  
		                }
			        }
		
		            Container {
			            layout: StackLayout {
			                        orientation: LayoutOrientation.LeftToRight
			                    }
			                    horizontalAlignment: HorizontalAlignment.Center
			            topPadding: 40
				        Label {
				            text: qsTr("Register:")
				            textStyle.base: SystemDefaults.TextStyles.BodyText
				            textStyle.textAlign: TextAlign.Right
				            horizontalAlignment: HorizontalAlignment.Right
				            verticalAlignment: VerticalAlignment.Center
				        }
			                    
		                ToggleButton {
		                    id: registerField
				            horizontalAlignment: HorizontalAlignment.Left
				            verticalAlignment: VerticalAlignment.Center
				            checked: _sipPhone.sipRegister
		                    onCheckedChanged: _sipPhone.sipRegister = checked
		                }
		            } 
		            /*
                    Divider {
                    }
			        Label {
			            text: qsTr("More options:")
			            textStyle.base: SystemDefaults.TextStyles.BodyText
			            textStyle.textAlign: TextAlign.Center
			            horizontalAlignment: HorizontalAlignment.Center
			            verticalAlignment: VerticalAlignment.Center
			        }
                    ListView {
                        dataModel: XmlDataModel {
                            source: "AccountSettings.xml"
                        } 

                        listItemComponents: ListItemComponent {
                            type: "appItem"

                            StandardListItem {
                                title: ListItemData.title
                                description: ListItemData.dsc
                                imageSource: ListItemData.icon
                            }
                        }

                        onTriggered: {
                            clearSelection();
                            var id=dataModel.data(indexPath).id;
                            var editor=advAccountEditor;
                            if (id=="1") editor=authAccountEditor;
                            else if (id=="2") editor=regAccountEditor; 
                            else if (id=="3") editor=natAccountEditor;
                             
                            accEditNavigationPane.push(editor.createObject());
                        }
                    }
		        }
		        */
		        }
		    }
	        actions: [
	            ActionItem {
	                title: "Advanced"
	                imageSource: "icons/icon_140.png"
	                ActionBar.placement: ActionBarPlacement.OnBar
	                onTriggered: {
	                    accEditNavigationPane.push(advAccountEditor.createObject());
	                }
	            },
	            ActionItem {
	                title: "Auth.options"
	                imageSource: "icons/icon_254.png"
	                ActionBar.placement: ActionBarPlacement.OnBar
	                onTriggered: {
	                    accEditNavigationPane.push(authAccountEditor.createObject());
	                }
	            },
	            ActionItem {
	                title: "Registration"
	                imageSource: "icons/icon_205.png"
	                ActionBar.placement: ActionBarPlacement.OnBar
	                onTriggered: {
	                    accEditNavigationPane.push(regAccountEditor.createObject());
	                }
	            },
	            ActionItem {
	                title: "NAT Traversal"
	                imageSource: "icons/icon_089.png"
	                ActionBar.placement: ActionBarPlacement.OnBar
	                onTriggered: {
	                    accEditNavigationPane.push(natAccountEditor.createObject());
	                }
	            },
	            ActionItem {
	                title: "Clear advanced settings"
	                imageSource: "icons/icon_278.png"
	                ActionBar.placement: ActionBarPlacement.OnBar
	                onTriggered: {
		                _sipPhone.clearAdvancedSettings();
	                }
	            },
                DeleteActionItem {
                    title: "Clear all settings"
		            onTriggered: {
		                _sipPhone.clearAccountSettings();
		                domainField.text="";		                
		                userNameField.text="";		                
		                passwordField.text="";		                
		            }
                }
	        ]
	    }
	}
}