// Default empty project template
import bb.cascades 1.0
import bb.system 1.0
import bb.multimedia 1.0

// creates one page with a label
TabbedPane {
    showTabsOnActionBar: true
    id: mainTabbedPane
    objectName: "mainTabbedPane"
    Menu.definition: MenuDefinition {
        // Specify the actions that should be included in the menu
        actions: [
            ActionItem {
                title: qsTr("Invite")
                imageSource: "icons/ic_bbm_medium.png"

                enabled: _bbmController.bbmAllowed
                onTriggered: {
                    _bbmController.sendInvToDownload();
                }
            },
  			ActionItem {
                title: qsTr("Options")
                imageSource: "icons/icon_186.png"
                  
                onTriggered: {
                    if (mainTabbedPane.activeTab == dialpadTab) {
                        _sipPhone.activeNavigationPane = navigationPane;
                        navigationPane.push(optionsSelector.createObject());
                    } else {
                        _sipPhone.activeNavigationPane = callogPane
                        callogPane.push(optionsSelector.createObject());
                    }
                }
            },
            ActionItem {
                title: qsTr("Support")
                imageSource: "icons/icon_289.png"
                onTriggered: {
                    _invController.contactDeveloper();
                }
            },
            ActionItem {
                title: qsTr("Account")
                imageSource: "icons/icon_279.png"
                  
                onTriggered: {
                    //navigationPane.push(accountEditor.createObject());
                    _sipPhone.enterCurrentAccountEdittingOrCreateNew();
                    //accountEditorSheet.open();
                    accountEditor.createObject().open();
                }
            }
        ] // end of actions list
    } // end of MenuDefinition
    
    onActiveTabChanged: {
        //if (activeTab==dialpadTab){
        //    destText.requestFocus();
        //}
        networkImage.imageSource=_sipPhone.networkType==0?"asset:///icons/small/icon_182.png":(_sipPhone.networkType ==7?"asset:///icons/small/145_signal.png": "asset:///icons/small/icon_280.png")
    }

    onCreationCompleted: {
        _bbmController.startBBMRegistration();
    }
    
    Tab {
        title: qsTr("Dial Pad")
        imageSource: "icons/large/keypad.png"
        description: "Dialing out by entering phone number or SIP URI"
        objectName: "DialerTab"
        id: dialpadTab
        //attachedObjects: [
        //    ComponentDefinition {
        //        id: dialpadPage
        //        source: "Dialpad.qml"
        //    }
        //]
        //onCreationCompleted: {
        //    content = dialpadPage.createObject();
        //}
        
        NavigationPane {
            id: navigationPane
            objectName: "navigationPane"

            onPopTransitionEnded: {
                page.destroy();
            }
            
            function onActiveCallDetected() {
                activeCallSheet.createObject().open();
            }
            function onSipAccountNeeded() {
                _sipPhone.enterAccountEditing();
                accountEditor.createObject().open();
            }
            // Add the application menu using a MenuDefinition

            attachedObjects: [
                ComponentDefinition {
                    id: activeCallSheet
                    source: "ActiveCall.qml"
                },
                ComponentDefinition {
                    id: accountEditor
                    source: "AccountEditor.qml"
                },
                ComponentDefinition {
                    id: settingsEditor
                    source: "SettingEditor.qml"
                },
                ComponentDefinition {
                    id: optionsSelector
                    source: "OptionsSelector.qml"
                },
                SystemSound {
                    id: beepSound
                    sound: SystemSound.InputKeypress
                }
            ]

            Page {
                onCreationCompleted: {
                    destText.requestFocus();
                }
                actions: [
                    // define the actions for first tab here
                    ActionItem {
                        title: qsTr("Contacts")
                        ActionBar.placement: ActionBarPlacement.OnBar
                        imageSource: "icons/large/icon_273.png"
                        onTriggered: {
                            _sipPhone.searchContact(true);
                        }
                    }
                ]

                Container {
                    layout: StackLayout {
                        orientation: LayoutOrientation.TopToBottom
                    }
                    Container {
                        Container {
                            layout: StackLayout {
                                orientation: LayoutOrientation.LeftToRight
                            }
                            horizontalAlignment: HorizontalAlignment.Left
                            verticalAlignment: VerticalAlignment.Center
                            ImageView {
                                objectName: "networkImage"
                                //preferredHeight: 64
                                //preferredWidth: 64
                                minWidth: 64
                                horizontalAlignment: HorizontalAlignment.Left
                                verticalAlignment: VerticalAlignment.Center

                                imageSource: _sipPhone.networkType==0?"asset:///icons/small/icon_182.png":(_sipPhone.networkType ==7?"asset:///icons/small/145_signal.png": "asset:///icons/small/icon_280.png") 
                            }
                            
                            ImageView {
	                             objectName: "regImage"
	                             preferredHeight: 64
	                             preferredWidth: 64
                                 minWidth: 64
	                             horizontalAlignment: HorizontalAlignment.Left
	                             verticalAlignment: VerticalAlignment.Center
	                             
	                             imageSource: _sipPhone.selectedAccountRegStatus==0?"asset:///icons/small/icon_194.png": _sipPhone.selectedAccountRegStatus == -3 ? "asset:///icons/greyball.png" : _sipPhone.selectedAccountRegStatus == -2? "asset:///icons/redball.png": _sipPhone.selectedAccountRegStatus == -1 ? "asset:///icons/small/icon_180.png": _sipPhone.selectedAccountRegStatus == 1 ? "asset:///icons/small/icon_181.png":"asset:///icons/small/icon_251.png"
                            }
                            DropDown {
                               	id: accountsListDropDown
                                objectName: "accountsListDropDown"
                                onExpandedChanged: {
                                    title=expanded?"Account:":"";
                                }
                                
                                onSelectedValueChanged: {
                                    if (selectedValue=="addAccount") {
                                        _sipPhone.enterAddingAccount();
                                        accountEditor.createObject().open();
                                    } else {
                                        _sipPhone.setSelectedAccountIDFromUI(selectedValue);
                                    }
                                }
                            }
                            /*
                            Label {
                                objectName: "regLabel"
                                //text: qsTr("No SIP account configured")
                                text: qsTr(_sipPhone.sipAccountText)
                                textStyle.base: SystemDefaults.TextStyles.BodyText
                                textStyle.textAlign: TextAlign.Left
                                horizontalAlignment: HorizontalAlignment.Fill
                                verticalAlignment: VerticalAlignment.Center

                            }
                            */
                        }
                    }
                    Divider {
                    }
                    Container {
                        layout: StackLayout {
                            orientation: LayoutOrientation.LeftToRight
                        }
                        topMargin: 20.0
                        topPadding: 20.0
                        ImageToggleButton {
                            imageSourceDefault: "icons/small/icon_128.png"
                            imageSourceChecked: "icons/small/icon_201.png"
                            verticalAlignment: VerticalAlignment.Center
                            minWidth: 64
                            onCheckedChanged: {
                                if (checked) {
                                    destText.hintText = "[Destination to call]";
                                    destText.inputMode = TextFieldInputMode.Default;
                                    destText.input.flags = TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboard | TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff
                                    destText.requestFocus();
                                } else {
                                    destText.hintText = "[Number to call]";
                                    destText.inputMode = TextFieldInputMode.PhoneNumber;
                                    destText.input.flags = TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboardOff | TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff
                                    destText.requestFocus();
                                }
                            }
                        }
                        ImageToggleButton {
                            id: digitSoundOn
                            minWidth: 64
                            imageSourceDefault: "icons/small/icon_162.png"
                            imageSourceChecked: "icons/small/icon_161.png"
                            checked: true
                            verticalAlignment: VerticalAlignment.Center
                        }
                        TextField {
                            objectName: "destText"
                            id: destText
                            hintText: "[Number to call]"
                            textStyle.base: SystemDefaults.TextStyles.TitleText
                            verticalAlignment: VerticalAlignment.Center
                            horizontalAlignment: HorizontalAlignment.Fill
                            preferredHeight: 85.0
                            leftMargin: 0
                            leftPadding: 0
                            inputMode: TextFieldInputMode.PhoneNumber
                            textStyle.fontWeight: FontWeight.Bold
                            textStyle.fontSize: FontSize.XLarge
                            textStyle.textAlign: TextAlign.Default
                            input.submitKey: SubmitKey.Connect
                            input.flags:TextInputFlag.SpellCheckOff | TextInputFlag.VirtualKeyboardOff | TextInputFlag.WordSubstitutionOff | TextInputFlag.AutoCapitalizationOff
                            backgroundVisible: false
                            textStyle.color: Color.White
                            text: _sipPhone.initNumber
                            //text: _sipPhone.networkType
                            input {
                                
                                onSubmitted: {
                                    _sipPhone.dial(destText.text);
                                }
                                submitKeyFocusBehavior: SubmitKeyFocusBehavior.Lose
                            }
                        }
                    }
                    Container {
                        id: dialPadSubTab
                        layout: AbsoluteLayout {
                        }
                        onCreationCompleted: {
                            destText.requestFocus();
                        }

                        function digitClicked(digit){
                            destText.text += digit;
                            destText.requestFocus();
                            if (digitSoundOn.checked) {
                            	beepSound.play();
                            }
                        }

                        horizontalAlignment: HorizontalAlignment.Center
                        verticalAlignment: VerticalAlignment.Center

                        property int offset: 48
                        property int gapV: 150
                        property int offsetH1: 2
                        property int offsetH2: 243
                        property int offsetH3: 484

                        Divider {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: 0
                                positionY: dialPadSubTab.offset-12
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH1
                                positionY: dialPadSubTab.offset
                            }
                            defaultImageSource: "asset:///buttons/1.png"
                            pressedImageSource: "asset:///buttons/1pressed.png"
                            focusPolicy: FocusPolicy.None
                            onClicked: {
                                dialPadSubTab.digitClicked("1");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH2
                                positionY: dialPadSubTab.offset
                            }
                            defaultImageSource: "asset:///buttons/2.png"
                            pressedImageSource: "asset:///buttons/2pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("2");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH3
                                positionY: dialPadSubTab.offset
                            }
                            defaultImageSource: "asset:///buttons/3.png"
                            pressedImageSource: "asset:///buttons/3pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("3");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH1
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV
                            }
                            defaultImageSource: "asset:///buttons/4.png"
                            pressedImageSource: "asset:///buttons/4pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("4");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH2
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV
                            }
                            defaultImageSource: "asset:///buttons/5.png"
                            pressedImageSource: "asset:///buttons/5pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("5");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH3
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV
                            }
                            defaultImageSource: "asset:///buttons/6.png"
                            pressedImageSource: "asset:///buttons/6pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("6");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH1
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV*2
                            }
                            defaultImageSource: "asset:///buttons/7.png"
                            pressedImageSource: "asset:///buttons/7pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("7");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH2
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV * 2
                            }
                            defaultImageSource: "asset:///buttons/8.png"
                            pressedImageSource: "asset:///buttons/8pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("8");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH3
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV * 2
                            }
                            defaultImageSource: "asset:///buttons/9.png"
                            pressedImageSource: "asset:///buttons/9pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("9");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH1
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV * 3
                            }
                            defaultImageSource: "asset:///buttons/star.png"
                            pressedImageSource: "asset:///buttons/starpressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("*");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH2
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV * 3
                            }
                            defaultImageSource: "asset:///buttons/0.png"
                            pressedImageSource: "asset:///buttons/0pressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("0");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH3
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV * 3
                            }
                            defaultImageSource: "asset:///buttons/pound.png"
                            pressedImageSource: "asset:///buttons/poundpressed.png"
                            onClicked: {
                                dialPadSubTab.digitClicked("#");
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH1
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV * 4
                            }
                            defaultImageSource: "asset:///buttons/call.png"
                            pressedImageSource: "asset:///buttons/callpressed.png"
                            onClicked: {
                                _sipPhone.dial(destText.text);
                            }
                        }
                        ImageButton {
                            layoutProperties: AbsoluteLayoutProperties {
                                positionX: dialPadSubTab.offsetH3
                                positionY: dialPadSubTab.offset + dialPadSubTab.gapV * 4
                            }
                            defaultImageSource: "asset:///buttons/backspace.png"
                            pressedImageSource: "asset:///buttons/backspacepressed.png"
                            onClicked: {
                                if (digitSoundOn.checked) {
                                    beepSound.play();
                                }
                                if (destText.text.length>0){
                                    destText.text= destText.text.slice(0, destText.text.length-1);
                                }
                                destText.requestFocus();
                            }
                        }
                    }
                }
            }
        }
    }
    Tab {
        title: "Call log"
        imageSource: "icons/large/109_History.png"
        description: "History of incoming,outgoing and missed calls"
        objectName: "DialerTab"
        id: calllogTab
        NavigationPane {
            id: callogPane
            objectName: "callogPane"

            onPopTransitionEnded: {
                page.destroy();
            }
            attachedObjects: [
                ComponentDefinition {
                    id: callInfoPage
                    source: "CallInfoPage.qml"
                }
            ]
            Page {
                actions: [
                    ActionItem {
                        title: "Clear Call Log"
                        imageSource: "icons/icon_099.png"

                        attachedObjects: [
                            SystemDialog {
                                id: myClearCallsPrompt
                                title: "Warning"
                                body: "Are you sure you want to clear all call records?"
                                onFinished: {
                                    if (myClearCallsPrompt.result == SystemUiResult.ConfirmButtonSelection) _sipPhone.clearCallHistory();
                                }
                            }
                        ]
                        onTriggered: {
                            //_sipPhone.clearCallHistory();
                            myClearCallsPrompt.show();
                        }
                    },
                    ActionItem {
                        title: "Purge Call Log"
                        imageSource: "icons/icon_098.png"

                        onTriggered: {
                            _sipPhone.purgeCallHistory();
                        }
                    }
                ]

                Container {
                    layout: StackLayout {
                        orientation: LayoutOrientation.TopToBottom
                    }
                    Container {
                        layout: StackLayout {
                            orientation: LayoutOrientation.LeftToRight
                        }
                        horizontalAlignment: HorizontalAlignment.Left
                        ImageView {
                            objectName: "networkImage"
                            id: networkImage
                            minWidth: 64
                            horizontalAlignment: HorizontalAlignment.Left
                            verticalAlignment: VerticalAlignment.Center
                            
                            imageSource: _sipPhone.networkType==0?"asset:///icons/small/icon_182.png":(_sipPhone.networkType ==7?"asset:///icons/small/145_signal.png": "asset:///icons/small/icon_280.png") 
                        }
                        ImageView {
                            objectName: "regImage"
                            preferredHeight: 64
                            preferredWidth: 64
                            minWidth: 64
                            horizontalAlignment: HorizontalAlignment.Left
                            verticalAlignment: VerticalAlignment.Center
                            
                            imageSource: _sipPhone.selectedAccountRegStatus==0?"asset:///icons/small/icon_194.png": _sipPhone.selectedAccountRegStatus == -3 ? "asset:///icons/greyball.png" : _sipPhone.selectedAccountRegStatus == -2? "asset:///icons/redball.png": _sipPhone.selectedAccountRegStatus == -1 ? "asset:///icons/small/icon_180.png": _sipPhone.selectedAccountRegStatus == 1 ? "asset:///icons/small/icon_181.png":"asset:///icons/small/icon_251.png"
                        }
                        DropDown {
                            id: accountsListDropDown2
                            objectName: "accountsListDropDown2"
                            onExpandedChanged: {
                                title=expanded?"Account:":"";
                            }
                            
                            onSelectedValueChanged: {
                                if (selectedValue=="addAccount") {
                                    _sipPhone.enterAddingAccount();
                                    accountEditor.createObject().open();
                                } else {
                                    _sipPhone.setSelectedAccountIDFromUI(selectedValue);
                                }
                            }
                        }
                    }
                    SegmentedControl {
                        id: segmentedControl
                        Option {
                            text: "All"
                            value: "1"
                            selected: true
                        }
                        Option {
                            text: "Missed"
                            value: "2"
                        }
                        onSelectedIndexChanged: {
                            var value = segmentedControl.selectedValue;
                            _sipPhone.setCallHistoryMode(parseInt(value));
                        }
                    }
                    Container {
                        layout: DockLayout {
                        }
                        verticalAlignment: VerticalAlignment.Center

                        Container {
                            leftPadding: 10
                            rightPadding: 10
                            topPadding: 0
                            bottomPadding: 0
                            id: historySubTab

                            layout: StackLayout {
                                orientation: LayoutOrientation.TopToBottom
                            }
                            ListView {
                                /*
                                leadingVisual: Container {
                                    onCreationCompleted: {
                                        networkImage.imageSource=_sipPhone.networkType==0?"asset:///icons/small/icon_182.png":(_sipPhone.networkType ==7?"asset:///icons/small/145_signal.png": "asset:///icons/small/icon_280.png")
                                    }
                                    Container {
                                        layout: StackLayout {
                                            orientation: LayoutOrientation.LeftToRight
                                        }
                                        horizontalAlignment: HorizontalAlignment.Left
                                        ImageView {
                                            objectName: "networkImage"
                                            id: networkImage
                                            minWidth: 64
                                            horizontalAlignment: HorizontalAlignment.Left
                                            verticalAlignment: VerticalAlignment.Center
                                            
                                            imageSource: _sipPhone.networkType==0?"asset:///icons/small/icon_182.png":(_sipPhone.networkType ==7?"asset:///icons/small/145_signal.png": "asset:///icons/small/icon_280.png") 
                                        }
                                        ImageView {
                                            objectName: "regImage"
                                            preferredHeight: 64
                                            preferredWidth: 64
                                            minWidth: 64
                                            horizontalAlignment: HorizontalAlignment.Left
                                            verticalAlignment: VerticalAlignment.Center
                                            
                                            imageSource: _sipPhone.selectedAccountRegStatus==0?"asset:///icons/small/icon_194.png": _sipPhone.selectedAccountRegStatus == -3 ? "asset:///icons/greyball.png" : _sipPhone.selectedAccountRegStatus == -2? "asset:///icons/redball.png": _sipPhone.selectedAccountRegStatus == -1 ? "asset:///icons/small/icon_180.png": _sipPhone.selectedAccountRegStatus == 1 ? "asset:///icons/small/icon_181.png":"asset:///icons/small/icon_251.png"
                                        }
                                        DropDown {
                                            id: accountsListDropDown2
                                            objectName: "accountsListDropDown2"
                                            onExpandedChanged: {
                                                title=expanded?"Account:":"";
                                            }
                                            
                                            onSelectedValueChanged: {
                                                if (selectedValue=="addAccount") {
                                                    _sipPhone.enterAddingAccount();
                                                    accountEditor.createObject().open();
                                                } else {
                                                    _sipPhone.setSelectedAccountIDFromUI(selectedValue);
                                                }
                                            }
                                        }
                                    }
                                }
                                */
                                id: callHistoryListView
                                dataModel: _sipPhone.callHistory
                                function formatDay(dayDate) {
                                    return _sipPhone.formatDay(dayDate);
                                }
                                
                                signal dialRequested(string address)
                                signal contactRequested(string address)
                                signal deleteCallHistory(string address)
                                signal callInfoRequested(string callID);

                                onTouchCapture: {
                                    _sipPhone.callHistoryTouchCaptured(! destText.focused);
                                }

                                listItemComponents: [
                                    ListItemComponent {
                                    type: "header"
	                                    Header {
	                                        id: headerItem
	                                        title: headerItem.ListItem.view.formatDay(ListItemData)
	                                        //title: ListItemData.toLocaleFormat('%d-%b-%Y');//.toString("yyyy-MM-dd");
	                                    }
	                                },
                                
	                                ListItemComponent {
	                                    type: "item"
	
	                                    StandardListItem {
	                                        id: histItem
	                                        title: ListItemData.address
	                                        description: ListItemData.name
	                                        status: ListItemData.callTimeStr
	                                        imageSource: ListItemData.type == 0 ? "asset:///icons/icon_123.png" : ListItemData.type == 1 ? "asset:///icons/icon_124.png" : "asset:///icons/icon_125.png"
	                                        contextActions: [
	                                            // Add a set of four actions to the context menu for
	                                            // a list item
	                                            ActionSet {
	                                                ActionItem {
	                                                    title: "Call " + ListItemData.address
	                                                    imageSource: "asset:///icons/icon_126.png"
	
	                                                    onTriggered: {
	                                                        histItem.ListItem.view.dialRequested(ListItemData.address);
	                                                    }
	                                                }
	                                                ActionItem {
	                                                    title: "Contact"
	                                                    imageSource: "asset:///icons/icon_273.png"
	
	                                                    onTriggered: {
	                                                        histItem.ListItem.view.contactRequested(ListItemData.address);
	                                                    }
	                                                }
	                                                ActionItem {
	                                                    title: "Info"
	                                                    imageSource: "asset:///icons/icon_252.png"
	
	                                                    onTriggered: {
	                                                        //provide callID here
	                                                        histItem.ListItem.view.callInfoRequested(ListItemData.callID);
	                                                    }
	                                                }
	                                                DeleteActionItem {
	                                                    attachedObjects: [
	                                                        SystemDialog {
	                                                            id: myQmlDialog
	                                                            title: "Warning"
	                                                            body: "Are you sure you want to delete call records for "+ListItemData.address+"?"
	                                                            onFinished: {
	                                                                if (myQmlDialog.result == SystemUiResult.ConfirmButtonSelection) histItem.ListItem.view.deleteCallHistory(ListItemData.address);
	                                                            }
	                                                        }
	                                                    ]
	                                                    onTriggered: {
	                                                        //histItem.ListItem.view.deleteCallHistory(ListItemData.address);
	                                                        myQmlDialog.show();
	                                                    }
	                                                }
	
	                                            } // end of ActionSet
	                                        ]
	                                    }
	                                }
	                            ]
                                
                                onDialRequested: {
                                    _sipPhone.dial(address);
                                }

                                onDeleteCallHistory: {
                                    _sipPhone.deleteCallHistory(address);
                                }

                                onContactRequested: {
                                    _sipPhone.contactRequested(address);
                                }
                                
                                onCallInfoRequested: {
                                    //populate call details with callID
                                    _sipPhone.getCallInfo(parseInt(callID));
                                    callogPane.push(callInfoPage.createObject());
                                }

                                onTriggered: {
                                    clearSelection()
                                    select(indexPath)

                                    _sipPhone.dialFromCallHistory(indexPath)

                                }
                            }
                        }
                    }
                }
            }
        }
    }
    /*
    Tab {
        title: "Options"
        imageSource: "icons/icon_099.png"
        description: "Variety of sip.fm options and features"
        objectName: "OptionsTab"
        id: optionsTab
	    attachedObjects: [
	        ComponentDefinition {
                id: optionsPage
                source: "OptionsSelector.qml"
	        }
	    ]    
        onCreationCompleted: {
            optionsTab.content= optionsPage.createObject();
        }
    }
	Tab {
        title: "Status"
        imageSource: "icons/icon_099.png"
        description: "Network and registration status"
        objectName: "StatusTab"
        
	    attachedObjects: [
	        ComponentDefinition {
                id: networkSettingPage
                source: "SettingEditor.qml"
	        }
	    ]    
        onCreationCompleted: {
            content=networkSettingPage.createObject();
        }
    }
    */
}
